/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.security.SecurityContext;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.SetRole;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;

public class SetRoleTask
implements DataDefinitionTask<SetRole> {
    @Override
    public String getName() {
        return "SET ROLE";
    }

    @Override
    public ListenableFuture<?> execute(SetRole statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        SelectedRole.Type type;
        Session session = stateMachine.getSession();
        String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
        if (statement.getType() == SetRole.Type.ROLE) {
            accessControl.checkCanSetRole(SecurityContext.of(session), statement.getRole().map(c -> c.getValue().toLowerCase(Locale.ENGLISH)).get(), catalog);
        }
        switch (statement.getType()) {
            case ROLE: {
                type = SelectedRole.Type.ROLE;
                break;
            }
            case ALL: {
                type = SelectedRole.Type.ALL;
                break;
            }
            case NONE: {
                type = SelectedRole.Type.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + statement.getType());
            }
        }
        stateMachine.addSetRole(catalog, new SelectedRole(type, statement.getRole().map(c -> c.getValue().toLowerCase(Locale.ENGLISH))));
        return Futures.immediateFuture(null);
    }
}

