/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.SetTableAuthorization;
import io.prestosql.transaction.TransactionManager;
import java.util.List;

public class SetTableAuthorizationTask
implements DataDefinitionTask<SetTableAuthorization> {
    @Override
    public String getName() {
        return "SET TABLE AUTHORIZATION";
    }

    @Override
    public ListenableFuture<?> execute(SetTableAuthorization statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource());
        CatalogName catalogName = metadata.getCatalogHandle(session, tableName.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + tableName.getCatalogName()));
        metadata.getTableHandle(session, tableName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName));
        PrestoPrincipal principal = MetadataUtil.createPrincipal(statement.getPrincipal());
        if (principal.getType() == PrincipalType.ROLE && !metadata.listRoles(session, catalogName.getCatalogName()).contains(principal.getName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", principal.getName());
        }
        accessControl.checkCanSetTableAuthorization(session.toSecurityContext(), tableName, principal);
        metadata.setTableAuthorization(session, tableName.asCatalogSchemaTableName(), principal);
        return Futures.immediateFuture(null);
    }
}

