/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

final class InternalBlockEncodingSerde
implements BlockEncodingSerde {
    private final Function<String, BlockEncoding> blockEncodings;
    private final Function<TypeId, Type> types;

    public InternalBlockEncodingSerde(Function<String, BlockEncoding> blockEncodings, Function<TypeId, Type> types) {
        this.blockEncodings = Objects.requireNonNull(blockEncodings, "blockEncodings is null");
        this.types = Objects.requireNonNull(types, "types is null");
    }

    public Block readBlock(SliceInput input) {
        String encodingName = InternalBlockEncodingSerde.readLengthPrefixedString(input);
        BlockEncoding blockEncoding = this.blockEncodings.apply(encodingName);
        return blockEncoding.readBlock((BlockEncodingSerde)this, input);
    }

    public void writeBlock(SliceOutput output, Block block) {
        String encodingName;
        BlockEncoding blockEncoding;
        Optional replacementBlock;
        while ((replacementBlock = (blockEncoding = this.blockEncodings.apply(encodingName = block.getEncodingName())).replacementBlockForWrite(block)).isPresent()) {
            block = (Block)replacementBlock.get();
        }
        InternalBlockEncodingSerde.writeLengthPrefixedString(output, encodingName);
        blockEncoding.writeBlock((BlockEncodingSerde)this, output, block);
    }

    public Type readType(SliceInput sliceInput) {
        Objects.requireNonNull(sliceInput, "sliceInput is null");
        String id = InternalBlockEncodingSerde.readLengthPrefixedString(sliceInput);
        Type type = this.types.apply(TypeId.of((String)id));
        if (type == null) {
            throw new IllegalArgumentException("Unknown type " + id);
        }
        return type;
    }

    public void writeType(SliceOutput sliceOutput, Type type) {
        Objects.requireNonNull(sliceOutput, "sliceOutput is null");
        Objects.requireNonNull(type, "type is null");
        InternalBlockEncodingSerde.writeLengthPrefixedString(sliceOutput, type.getTypeId().getId());
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

