/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.Lifespan;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;

public final class Split {
    private final CatalogName catalogName;
    private final ConnectorSplit connectorSplit;
    private final Lifespan lifespan;

    @JsonCreator
    public Split(@JsonProperty(value="catalogName") CatalogName catalogName, @JsonProperty(value="connectorSplit") ConnectorSplit connectorSplit, @JsonProperty(value="lifespan") Lifespan lifespan) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.connectorSplit = Objects.requireNonNull(connectorSplit, "connectorSplit is null");
        this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
    }

    @JsonProperty
    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public ConnectorSplit getConnectorSplit() {
        return this.connectorSplit;
    }

    @JsonProperty
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    public Object getInfo() {
        return this.connectorSplit.getInfo();
    }

    public List<HostAddress> getAddresses() {
        return this.connectorSplit.getAddresses();
    }

    public boolean isRemotelyAccessible() {
        return this.connectorSplit.isRemotelyAccessible();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("connectorSplit", (Object)this.connectorSplit).add("lifespan", (Object)this.lifespan).toString();
    }
}

