/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class DeleteOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY);
    private final OperatorContext operatorContext;
    private final int rowIdChannel;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean closed;
    private ListenableFuture<Collection<Slice>> finishFuture;
    private Supplier<Optional<UpdatablePageSource>> pageSource = Optional::empty;

    public DeleteOperator(OperatorContext operatorContext, int rowIdChannel) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.rowIdChannel = rowIdChannel;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
            this.finishFuture = MoreFutures.toListenableFuture((CompletableFuture)this.pageSource().finish());
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        Block rowIds = page.getBlock(this.rowIdChannel);
        this.pageSource().deleteRows(rowIds);
        this.rowCount += (long)rowIds.getPositionCount();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.finishFuture == null) {
            return NOT_BLOCKED;
        }
        return this.finishFuture;
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING || !this.finishFuture.isDone()) {
            return null;
        }
        this.state = State.FINISHED;
        Collection fragments = (Collection)MoreFutures.getFutureValue(this.finishFuture);
        PageBuilder page = new PageBuilder(fragments.size() + 1, TYPES);
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        BlockBuilder fragmentBuilder = page.getBlockBuilder(1);
        page.declarePosition();
        BigintType.BIGINT.writeLong(rowsBuilder, this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            page.declarePosition();
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        return page.build();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.finishFuture != null) {
                this.finishFuture.cancel(true);
            } else {
                this.pageSource.get().ifPresent(UpdatablePageSource::abort);
            }
        }
    }

    public void setPageSource(Supplier<Optional<UpdatablePageSource>> pageSource) {
        this.pageSource = Objects.requireNonNull(pageSource, "pageSource is null");
    }

    private UpdatablePageSource pageSource() {
        Optional<UpdatablePageSource> source = this.pageSource.get();
        Preconditions.checkState((boolean)source.isPresent(), (Object)"UpdatablePageSource not set");
        return source.get();
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class DeleteOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final int rowIdChannel;
        private boolean closed;

        public DeleteOperatorFactory(int operatorId, PlanNodeId planNodeId, int rowIdChannel) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.rowIdChannel = rowIdChannel;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, DeleteOperator.class.getSimpleName());
            return new DeleteOperator(context, this.rowIdChannel);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new DeleteOperatorFactory(this.operatorId, this.planNodeId, this.rowIdChannel);
        }
    }
}

