/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.prestosql.array.LongBigArray;
import io.prestosql.operator.GroupByHash;
import io.prestosql.operator.GroupByIdBlock;
import io.prestosql.operator.GroupedTopNRowNumberAccumulator;
import io.prestosql.operator.PageWithPositionComparator;
import io.prestosql.operator.RowReferencePageManager;
import io.prestosql.operator.TransformWork;
import io.prestosql.operator.Work;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class GroupedTopNBuilder {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(GroupedTopNBuilder.class).instanceSize();
    private final List<Type> sourceTypes;
    private final boolean produceRowNumber;
    private final GroupByHash groupByHash;
    private final RowReferencePageManager pageManager = new RowReferencePageManager();
    private final GroupedTopNRowNumberAccumulator groupedTopNRowNumberAccumulator;

    public GroupedTopNBuilder(List<Type> sourceTypes, PageWithPositionComparator comparator, int topN, boolean produceRowNumber, GroupByHash groupByHash) {
        this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
        Preconditions.checkArgument((topN > 0 ? 1 : 0) != 0, (Object)"topN must be > 0");
        this.produceRowNumber = produceRowNumber;
        this.groupByHash = Objects.requireNonNull(groupByHash, "groupByHash is not null");
        Objects.requireNonNull(comparator, "comparator is null");
        this.groupedTopNRowNumberAccumulator = new GroupedTopNRowNumberAccumulator((leftRowId, rightRowId) -> {
            Page leftPage = this.pageManager.getPage(leftRowId);
            int leftPosition = this.pageManager.getPosition(leftRowId);
            Page rightPage = this.pageManager.getPage(rightRowId);
            int rightPosition = this.pageManager.getPosition(rightRowId);
            return comparator.compareTo(leftPage, leftPosition, rightPage, rightPosition);
        }, topN, this.pageManager::dereference);
    }

    public Work<?> processPage(Page page) {
        return new TransformWork<GroupByIdBlock, Object>(this.groupByHash.getGroupIds(page), groupIds -> {
            this.processPage(page, (GroupByIdBlock)groupIds);
            return null;
        });
    }

    public Iterator<Page> buildResult() {
        return new ResultIterator();
    }

    public long getEstimatedSizeInBytes() {
        return INSTANCE_SIZE + this.groupByHash.getEstimatedSize() + this.pageManager.sizeOf() + this.groupedTopNRowNumberAccumulator.sizeOf();
    }

    private void processPage(Page newPage, GroupByIdBlock groupIds) {
        try (RowReferencePageManager.LoadCursor loadCursor = this.pageManager.add(newPage);){
            GroupedTopNRowNumberAccumulator.RowReference rowReferenceView = GroupedTopNBuilder.asRowReferenceView(loadCursor);
            for (int position = 0; position < newPage.getPositionCount(); ++position) {
                long groupId = groupIds.getGroupId(position);
                loadCursor.advance();
                this.groupedTopNRowNumberAccumulator.add(groupId, rowReferenceView);
            }
            Verify.verify((!loadCursor.advance() ? 1 : 0) != 0);
        }
        this.pageManager.compactIfNeeded();
    }

    private static GroupedTopNRowNumberAccumulator.RowReference asRowReferenceView(final RowReferencePageManager.LoadCursor cursor) {
        return new GroupedTopNRowNumberAccumulator.RowReference(){

            @Override
            public int compareTo(LongComparator rowIdComparator, long rowId) {
                return cursor.compareTo(rowIdComparator, rowId);
            }

            @Override
            public long extractRowId() {
                return cursor.allocateRowId();
            }
        };
    }

    private class ResultIterator
    extends AbstractIterator<Page> {
        private final PageBuilder pageBuilder;
        private final long groupIdCount;
        private long currentGroupId;
        private final LongBigArray rowIdOutput;
        private long currentGroupSize;
        private int currentIndexInGroup;

        ResultIterator() {
            this.groupIdCount = GroupedTopNBuilder.this.groupByHash.getGroupCount();
            this.currentGroupId = -1L;
            this.rowIdOutput = new LongBigArray();
            ImmutableList.Builder sourceTypesBuilders = new ImmutableList.Builder().addAll(GroupedTopNBuilder.this.sourceTypes);
            if (GroupedTopNBuilder.this.produceRowNumber) {
                sourceTypesBuilders.add((Object)BigintType.BIGINT);
            }
            this.pageBuilder = new PageBuilder((List)sourceTypesBuilders.build());
        }

        protected Page computeNext() {
            this.pageBuilder.reset();
            while (!this.pageBuilder.isFull()) {
                while ((long)this.currentIndexInGroup >= this.currentGroupSize) {
                    if (this.currentGroupId + 1L >= this.groupIdCount) {
                        if (this.pageBuilder.isEmpty()) {
                            return (Page)this.endOfData();
                        }
                        return this.pageBuilder.build();
                    }
                    ++this.currentGroupId;
                    this.currentGroupSize = GroupedTopNBuilder.this.groupedTopNRowNumberAccumulator.drainTo(this.currentGroupId, this.rowIdOutput);
                    this.currentIndexInGroup = 0;
                }
                long rowId = this.rowIdOutput.get((long)this.currentIndexInGroup);
                Page page = GroupedTopNBuilder.this.pageManager.getPage(rowId);
                int position = GroupedTopNBuilder.this.pageManager.getPosition(rowId);
                for (int i = 0; i < GroupedTopNBuilder.this.sourceTypes.size(); ++i) {
                    GroupedTopNBuilder.this.sourceTypes.get(i).appendTo(page.getBlock(i), position, this.pageBuilder.getBlockBuilder(i));
                }
                if (GroupedTopNBuilder.this.produceRowNumber) {
                    BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(GroupedTopNBuilder.this.sourceTypes.size()), (long)(this.currentIndexInGroup + 1));
                }
                this.pageBuilder.declarePosition();
                ++this.currentIndexInGroup;
                GroupedTopNBuilder.this.pageManager.dereference(rowId);
            }
            if (this.pageBuilder.isEmpty()) {
                return (Page)this.endOfData();
            }
            return this.pageBuilder.build();
        }
    }
}

