/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Verify;
import io.prestosql.operator.LookupSource;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BigintType;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class JoinProbe {
    private final int[] probeOutputChannels;
    private final int positionCount;
    private final Block[] probeBlocks;
    private final Page page;
    private final Page probePage;
    private final Optional<Block> probeHashBlock;
    private int position = -1;

    private JoinProbe(int[] probeOutputChannels, Page page, List<Integer> probeJoinChannels, OptionalInt probeHashChannel) {
        this.probeOutputChannels = probeOutputChannels;
        this.positionCount = page.getPositionCount();
        this.probeBlocks = new Block[probeJoinChannels.size()];
        for (int i = 0; i < probeJoinChannels.size(); ++i) {
            this.probeBlocks[i] = page.getBlock(probeJoinChannels.get(i).intValue());
        }
        this.page = page;
        this.probePage = new Page(page.getPositionCount(), this.probeBlocks);
        this.probeHashBlock = probeHashChannel.isPresent() ? Optional.of(page.getBlock(probeHashChannel.getAsInt())) : Optional.empty();
    }

    public int[] getOutputChannels() {
        return this.probeOutputChannels;
    }

    public boolean advanceNextPosition() {
        Verify.verify((this.position < this.positionCount ? 1 : 0) != 0, (String)"already finished", (Object[])new Object[0]);
        ++this.position;
        return !this.isFinished();
    }

    public boolean isFinished() {
        return this.position == this.positionCount;
    }

    public long getCurrentJoinPosition(LookupSource lookupSource) {
        if (this.currentRowContainsNull()) {
            return -1L;
        }
        if (this.probeHashBlock.isPresent()) {
            long rawHash = BigintType.BIGINT.getLong(this.probeHashBlock.get(), this.position);
            return lookupSource.getJoinPosition(this.position, this.probePage, this.page, rawHash);
        }
        return lookupSource.getJoinPosition(this.position, this.probePage, this.page);
    }

    public int getPosition() {
        return this.position;
    }

    public Page getPage() {
        return this.page;
    }

    private boolean currentRowContainsNull() {
        for (Block probeBlock : this.probeBlocks) {
            if (!probeBlock.isNull(this.position)) continue;
            return true;
        }
        return false;
    }

    public static class JoinProbeFactory {
        private final int[] probeOutputChannels;
        private final List<Integer> probeJoinChannels;
        private final OptionalInt probeHashChannel;

        public JoinProbeFactory(int[] probeOutputChannels, List<Integer> probeJoinChannels, OptionalInt probeHashChannel) {
            this.probeOutputChannels = probeOutputChannels;
            this.probeJoinChannels = probeJoinChannels;
            this.probeHashChannel = probeHashChannel;
        }

        public JoinProbe createJoinProbe(Page page) {
            return new JoinProbe(this.probeOutputChannels, page, this.probeJoinChannels, this.probeHashChannel);
        }
    }
}

