/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Throwables;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.PagesIndexComparator;
import io.prestosql.operator.SyntheticAddress;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.type.BlockTypeOperators;
import java.util.Objects;

public class SimpleChannelComparator
implements PagesIndexComparator {
    private final int leftChannel;
    private final int rightChannel;
    private final BlockTypeOperators.BlockPositionComparison comparator;

    public SimpleChannelComparator(int leftChannel, int rightChannel, BlockTypeOperators.BlockPositionComparison comparator) {
        this.leftChannel = leftChannel;
        this.rightChannel = rightChannel;
        this.comparator = Objects.requireNonNull(comparator, "comparator is null");
    }

    @Override
    public int compareTo(PagesIndex pagesIndex, int leftPosition, int rightPosition) {
        long leftPageAddress = pagesIndex.getValueAddresses().getLong(leftPosition);
        int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
        int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
        long rightPageAddress = pagesIndex.getValueAddresses().getLong(rightPosition);
        int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
        int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
        try {
            Block leftBlock = (Block)pagesIndex.getChannel(this.leftChannel).get(leftBlockIndex);
            Block rightBlock = (Block)pagesIndex.getChannel(this.rightChannel).get(rightBlockIndex);
            return (int)this.comparator.compare(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
        }
    }
}

