/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.operator.DevNullOperator;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperationTimer;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.TableFinishInfo;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.StatisticAggregationsDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class TableFinishOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private final OperatorContext operatorContext;
    private final TableFinisher tableFinisher;
    private final Operator statisticsAggregationOperator;
    private final StatisticAggregationsDescriptor<Integer> descriptor;
    private State state = State.RUNNING;
    private long rowCount;
    private Optional<ConnectorOutputMetadata> outputMetadata = Optional.empty();
    private final ImmutableList.Builder<Slice> fragmentBuilder = ImmutableList.builder();
    private final ImmutableList.Builder<ComputedStatistics> computedStatisticsBuilder = ImmutableList.builder();
    private final OperationTimer.OperationTiming statisticsTiming = new OperationTimer.OperationTiming();
    private final boolean statisticsCpuTimerEnabled;

    public TableFinishOperator(OperatorContext operatorContext, TableFinisher tableFinisher, Operator statisticsAggregationOperator, StatisticAggregationsDescriptor<Integer> descriptor, boolean statisticsCpuTimerEnabled) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.tableFinisher = Objects.requireNonNull(tableFinisher, "tableCommitter is null");
        this.statisticsAggregationOperator = Objects.requireNonNull(statisticsAggregationOperator, "statisticsAggregationOperator is null");
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        this.statisticsCpuTimerEnabled = statisticsCpuTimerEnabled;
        operatorContext.setInfoSupplier(this::getInfo);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
        this.statisticsAggregationOperator.finish();
        timer.end(this.statisticsTiming);
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        if (this.state == State.FINISHED) {
            Verify.verify((boolean)this.statisticsAggregationOperator.isFinished());
            return true;
        }
        return false;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.statisticsAggregationOperator.isBlocked();
    }

    @Override
    public boolean needsInput() {
        if (this.state != State.RUNNING) {
            return false;
        }
        return this.statisticsAggregationOperator.needsInput();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        Block rowCountBlock = page.getBlock(0);
        Block fragmentBlock = page.getBlock(1);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (!rowCountBlock.isNull(position)) {
                this.rowCount += BigintType.BIGINT.getLong(rowCountBlock, position);
            }
            if (fragmentBlock.isNull(position)) continue;
            this.fragmentBuilder.add((Object)VarbinaryType.VARBINARY.getSlice(fragmentBlock, position));
        }
        TableFinishOperator.extractStatisticsRows(page).ifPresent(statisticsPage -> {
            OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
            this.statisticsAggregationOperator.addInput((Page)statisticsPage);
            timer.end(this.statisticsTiming);
        });
    }

    private static Optional<Page> extractStatisticsRows(Page page) {
        int statisticsPositionCount = 0;
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (!TableFinishOperator.isStatisticsPosition(page, position)) continue;
            ++statisticsPositionCount;
        }
        if (statisticsPositionCount == 0) {
            return Optional.empty();
        }
        if (statisticsPositionCount == page.getPositionCount()) {
            return Optional.of(page);
        }
        int selectedPositionsIndex = 0;
        int[] selectedPositions = new int[statisticsPositionCount];
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (!TableFinishOperator.isStatisticsPosition(page, position)) continue;
            selectedPositions[selectedPositionsIndex] = position;
            ++selectedPositionsIndex;
        }
        Block[] blocks = new Block[page.getChannelCount()];
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            blocks[channel] = page.getBlock(channel).getPositions(selectedPositions, 0, statisticsPositionCount);
        }
        return Optional.of(new Page(statisticsPositionCount, blocks));
    }

    private static boolean isStatisticsPosition(Page page, int position) {
        return page.getBlock(0).isNull(position) && page.getBlock(1).isNull(position);
    }

    @Override
    public Page getOutput() {
        if (!this.isBlocked().isDone()) {
            return null;
        }
        if (!this.statisticsAggregationOperator.isFinished()) {
            Verify.verify((boolean)this.statisticsAggregationOperator.isBlocked().isDone(), (String)"aggregation operator should not be blocked", (Object[])new Object[0]);
            OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
            Page page = this.statisticsAggregationOperator.getOutput();
            timer.end(this.statisticsTiming);
            if (page == null) {
                return null;
            }
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.computedStatisticsBuilder.add((Object)this.getComputedStatistics(page, position));
            }
            return null;
        }
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        this.outputMetadata = this.tableFinisher.finishTable((Collection<Slice>)this.fragmentBuilder.build(), (Collection<ComputedStatistics>)this.computedStatisticsBuilder.build());
        PageBuilder page = new PageBuilder(1, TYPES);
        page.declarePosition();
        BigintType.BIGINT.writeLong(page.getBlockBuilder(0), this.rowCount);
        return page.build();
    }

    private ComputedStatistics getComputedStatistics(Page page, int position) {
        ImmutableList.Builder groupingColumns = ImmutableList.builder();
        ImmutableList.Builder groupingValues = ImmutableList.builder();
        this.descriptor.getGrouping().forEach((column, channel) -> {
            groupingColumns.add(column);
            groupingValues.add((Object)page.getBlock(channel.intValue()).getSingleValueBlock(position));
        });
        ComputedStatistics.Builder statistics = ComputedStatistics.builder((List)groupingColumns.build(), (List)groupingValues.build());
        this.descriptor.getTableStatistics().forEach((type, channel) -> statistics.addTableStatistic(type, page.getBlock(channel.intValue()).getSingleValueBlock(position)));
        this.descriptor.getColumnStatistics().forEach((metadata, channel) -> statistics.addColumnStatistic(metadata, page.getBlock(channel.intValue()).getSingleValueBlock(position)));
        return statistics.build();
    }

    @VisibleForTesting
    TableFinishInfo getInfo() {
        return new TableFinishInfo(this.outputMetadata, new Duration((double)this.statisticsTiming.getWallNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.statisticsTiming.getCpuNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit());
    }

    @Override
    public void close() throws Exception {
        this.statisticsAggregationOperator.close();
    }

    public static interface TableFinisher {
        public Optional<ConnectorOutputMetadata> finishTable(Collection<Slice> var1, Collection<ComputedStatistics> var2);
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableFinishOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final TableFinisher tableFinisher;
        private final OperatorFactory statisticsAggregationOperatorFactory;
        private final StatisticAggregationsDescriptor<Integer> descriptor;
        private final Session session;
        private boolean closed;

        public TableFinishOperatorFactory(int operatorId, PlanNodeId planNodeId, TableFinisher tableFinisher, OperatorFactory statisticsAggregationOperatorFactory, StatisticAggregationsDescriptor<Integer> descriptor, Session session) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.tableFinisher = Objects.requireNonNull(tableFinisher, "tableFinisher is null");
            this.statisticsAggregationOperatorFactory = Objects.requireNonNull(statisticsAggregationOperatorFactory, "statisticsAggregationOperatorFactory is null");
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableFinishOperator.class.getSimpleName());
            Operator statisticsAggregationOperator = this.statisticsAggregationOperatorFactory.createOperator(driverContext);
            boolean statisticsCpuTimerEnabled = !(statisticsAggregationOperator instanceof DevNullOperator) && SystemSessionProperties.isStatisticsCpuTimerEnabled(this.session);
            return new TableFinishOperator(context, this.tableFinisher, statisticsAggregationOperator, this.descriptor, statisticsCpuTimerEnabled);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableFinishOperatorFactory(this.operatorId, this.planNodeId, this.tableFinisher, this.statisticsAggregationOperatorFactory, this.descriptor, this.session);
        }
    }
}

