/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.ApproximateMostFrequentHistogram;
import io.prestosql.operator.aggregation.LongApproximateMostFrequentStateFactory;
import io.prestosql.operator.aggregation.LongApproximateMostFrequentStateSerializer;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorState;
import io.prestosql.spi.function.AccumulatorStateMetadata;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.util.Failures;

@AggregationFunction(value="approx_most_frequent")
public final class BigintApproximateMostFrequent {
    private BigintApproximateMostFrequent() {
    }

    @InputFunction
    public static void input(@AggregationState State state, @SqlType(value="bigint") long buckets, @SqlType(value="bigint") long value, @SqlType(value="bigint") long capacity) {
        ApproximateMostFrequentHistogram<Long> histogram = state.get();
        if (histogram == null) {
            Failures.checkCondition(buckets >= 2L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "approx_most_frequent bucket count must be greater than one", new Object[0]);
            histogram = new ApproximateMostFrequentHistogram<Long>(Math.toIntExact(buckets), Math.toIntExact(capacity), LongApproximateMostFrequentStateSerializer::serializeBucket, LongApproximateMostFrequentStateSerializer::deserializeBucket);
            state.set(histogram);
        }
        histogram.add(value);
    }

    @CombineFunction
    public static void combine(@AggregationState State state, @AggregationState State otherState) {
        ApproximateMostFrequentHistogram<Long> otherHistogram = otherState.get();
        ApproximateMostFrequentHistogram<Long> histogram = state.get();
        if (histogram == null) {
            state.set(otherHistogram);
        } else {
            histogram.merge(otherHistogram);
        }
    }

    @OutputFunction(value="map(bigint,bigint)")
    public static void output(@AggregationState State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            BlockBuilder entryBuilder = out.beginBlockEntry();
            state.get().forEachBucket((key, value) -> {
                BigintType.BIGINT.writeLong(entryBuilder, key.longValue());
                BigintType.BIGINT.writeLong(entryBuilder, value);
            });
            out.closeEntry();
        }
    }

    @AccumulatorStateMetadata(stateSerializerClass=LongApproximateMostFrequentStateSerializer.class, stateFactoryClass=LongApproximateMostFrequentStateFactory.class)
    public static interface State
    extends AccumulatorState {
        public ApproximateMostFrequentHistogram<Long> get();

        public void set(ApproximateMostFrequentHistogram<Long> var1);
    }
}

