/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.slice.Slice;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.operator.aggregation.AccumulatorCompiler;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.state.LongDecimalWithOverflowAndLongStateSerializer;
import io.prestosql.operator.aggregation.state.LongDecimalWithOverflowState;
import io.prestosql.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import io.prestosql.operator.aggregation.state.LongDecimalWithOverflowStateSerializer;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.UnscaledDecimal128Arithmetic;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class DecimalSumAggregation
extends SqlAggregationFunction {
    public static final DecimalSumAggregation DECIMAL_SUM_AGGREGATION = new DecimalSumAggregation();
    private static final String NAME = "sum";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputShortDecimal", Type.class, LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputLongDecimal", Type.class, LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "outputLongDecimal", DecimalType.class, LongDecimalWithOverflowState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "combine", LongDecimalWithOverflowState.class, LongDecimalWithOverflowState.class);

    public DecimalSumAggregation() {
        super(new FunctionMetadata(new Signature(NAME, new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.numericParameter((long)38L), TypeSignatureParameter.typeVariable((String)"s")}), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}))), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, "Calculates the sum over the input values", FunctionKind.AGGREGATE), true, false);
    }

    @Override
    public List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        return ImmutableList.of((Object)new LongDecimalWithOverflowAndLongStateSerializer().getSerializedType().getTypeSignature());
    }

    @Override
    public InternalAggregationFunction specialize(FunctionBinding functionBinding) {
        Type inputType = (Type)Iterables.getOnlyElement(functionBinding.getBoundSignature().getArgumentTypes());
        Type outputType = functionBinding.getBoundSignature().getReturnType();
        return DecimalSumAggregation.generateAggregation(inputType, outputType);
    }

    private static InternalAggregationFunction generateAggregation(Type inputType, Type outputType) {
        Preconditions.checkArgument((boolean)(inputType instanceof DecimalType), (Object)"type must be Decimal");
        DynamicClassLoader classLoader = new DynamicClassLoader(DecimalSumAggregation.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)inputType);
        Class<LongDecimalWithOverflowState> stateInterface = LongDecimalWithOverflowState.class;
        LongDecimalWithOverflowStateSerializer stateSerializer = new LongDecimalWithOverflowStateSerializer();
        MethodHandle inputFunction = ((DecimalType)inputType).isShort() ? SHORT_DECIMAL_INPUT_FUNCTION : LONG_DECIMAL_INPUT_FUNCTION;
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), DecimalSumAggregation.createInputParameterMetadata(inputType), inputFunction.bindTo(inputType), Optional.empty(), COMBINE_FUNCTION, LONG_DECIMAL_OUTPUT_FUNCTION.bindTo(outputType), (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, stateSerializer, new LongDecimalWithOverflowStateFactory())), outputType);
        Type intermediateType = stateSerializer.getSerializedType();
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), outputType, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void inputShortDecimal(Type type, LongDecimalWithOverflowState state, Block block, int position) {
        DecimalSumAggregation.accumulateValueInState(UnscaledDecimal128Arithmetic.unscaledDecimal((long)type.getLong(block, position)), state);
    }

    public static void inputLongDecimal(Type type, LongDecimalWithOverflowState state, Block block, int position) {
        DecimalSumAggregation.accumulateValueInState(type.getSlice(block, position), state);
    }

    private static void accumulateValueInState(Slice unscaledDecimal, LongDecimalWithOverflowState state) {
        DecimalSumAggregation.initializeIfNeeded(state);
        Slice sum = state.getLongDecimal();
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((Slice)sum, (Slice)unscaledDecimal, (Slice)sum);
        state.setOverflow(state.getOverflow() + overflow);
    }

    private static void initializeIfNeeded(LongDecimalWithOverflowState state) {
        if (state.getLongDecimal() == null) {
            state.setLongDecimal(UnscaledDecimal128Arithmetic.unscaledDecimal());
        }
    }

    public static void combine(LongDecimalWithOverflowState state, LongDecimalWithOverflowState otherState) {
        state.setOverflow(state.getOverflow() + otherState.getOverflow());
        if (state.getLongDecimal() == null) {
            state.setLongDecimal(otherState.getLongDecimal());
        } else {
            DecimalSumAggregation.accumulateValueInState(otherState.getLongDecimal(), state);
        }
    }

    public static void outputLongDecimal(DecimalType type, LongDecimalWithOverflowState state, BlockBuilder out) {
        if (state.getLongDecimal() == null) {
            out.appendNull();
        } else {
            if (state.getOverflow() != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
            UnscaledDecimal128Arithmetic.throwIfOverflows((Slice)state.getLongDecimal());
            type.writeSlice(out, state.getLongDecimal());
        }
    }
}

