/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.prestosql.metadata.BoundSignature;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.operator.ParametricFunctionHelpers;
import io.prestosql.operator.ParametricImplementationsGroup;
import io.prestosql.operator.aggregation.AggregationHeader;
import io.prestosql.operator.aggregation.AggregationImplementation;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.LazyAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.state.StateCompiler;
import io.prestosql.operator.annotations.ImplementationDependency;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ParametricAggregation
extends SqlAggregationFunction {
    private final ParametricImplementationsGroup<AggregationImplementation> implementations;

    public ParametricAggregation(Signature signature, AggregationHeader details, ParametricImplementationsGroup<AggregationImplementation> implementations, boolean deprecated) {
        super(new FunctionMetadata(signature, true, implementations.getArgumentDefinitions(), details.isHidden(), true, details.getDescription().orElse(""), FunctionKind.AGGREGATE, deprecated), details.isDecomposable(), details.isOrderSensitive());
        Objects.requireNonNull(details, "details is null");
        Preconditions.checkArgument((boolean)implementations.isNullable(), (Object)"currently aggregates are required to be nullable");
        this.implementations = Objects.requireNonNull(implementations, "implementations is null");
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        ParametricAggregation.declareDependencies(builder, this.implementations.getExactImplementations().values());
        ParametricAggregation.declareDependencies(builder, this.implementations.getSpecializedImplementations());
        ParametricAggregation.declareDependencies(builder, this.implementations.getGenericImplementations());
        return builder.build();
    }

    private static void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder, Collection<AggregationImplementation> implementations) {
        for (AggregationImplementation implementation : implementations) {
            for (ImplementationDependency dependency : implementation.getInputDependencies()) {
                dependency.declareDependencies(builder);
            }
            for (ImplementationDependency dependency : implementation.getCombineDependencies()) {
                dependency.declareDependencies(builder);
            }
            for (ImplementationDependency dependency : implementation.getOutputDependencies()) {
                dependency.declareDependencies(builder);
            }
        }
    }

    @Override
    public List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        AggregationImplementation concreteImplementation = this.findMatchingImplementation(functionBinding.getBoundSignature());
        Type serializedType = StateCompiler.getSerializedType(concreteImplementation.getStateClass());
        return ImmutableList.of((Object)serializedType.getTypeSignature());
    }

    @Override
    public InternalAggregationFunction specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        Signature signature = this.getFunctionMetadata().getSignature();
        AggregationImplementation concreteImplementation = this.findMatchingImplementation(functionBinding.getBoundSignature());
        List<Type> inputTypes = functionBinding.getBoundSignature().getArgumentTypes();
        Type outputType = functionBinding.getBoundSignature().getReturnType();
        Class<?> definitionClass = concreteImplementation.getDefinitionClass();
        DynamicClassLoader classLoader = new DynamicClassLoader(definitionClass.getClassLoader(), this.getClass().getClassLoader());
        Class<?> stateClass = concreteImplementation.getStateClass();
        AccumulatorStateSerializer<?> stateSerializer = StateCompiler.generateStateSerializer(stateClass, classLoader);
        AccumulatorStateFactory<?> stateFactory = StateCompiler.generateStateFactory(stateClass, classLoader);
        MethodHandle inputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getInputFunction(), concreteImplementation.getInputDependencies(), functionBinding, functionDependencies);
        Optional<MethodHandle> removeInputHandle = concreteImplementation.getRemoveInputFunction().map(removeInputFunction -> ParametricFunctionHelpers.bindDependencies(removeInputFunction, concreteImplementation.getRemoveInputDependencies(), functionBinding, functionDependencies));
        MethodHandle combineHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getCombineFunction(), concreteImplementation.getCombineDependencies(), functionBinding, functionDependencies);
        MethodHandle outputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getOutputFunction(), concreteImplementation.getOutputDependencies(), functionBinding, functionDependencies);
        List<AggregationMetadata.ParameterMetadata> parametersMetadata = ParametricAggregation.buildParameterMetadata(concreteImplementation.getInputParameterMetadataTypes(), inputTypes);
        String aggregationName = AggregationUtils.generateAggregationName(signature.getName(), outputType.getTypeSignature(), ParametricAggregation.signaturesFromTypes(inputTypes));
        AggregationMetadata aggregationMetadata = new AggregationMetadata(aggregationName, parametersMetadata, inputHandle, removeInputHandle, combineHandle, outputHandle, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateClass, stateSerializer, stateFactory)), outputType);
        return new InternalAggregationFunction(signature.getName(), inputTypes, (List<Type>)ImmutableList.of((Object)stateSerializer.getSerializedType()), outputType, new LazyAccumulatorFactoryBinder(aggregationMetadata, classLoader));
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<AggregationImplementation> getImplementations() {
        return this.implementations;
    }

    private AggregationImplementation findMatchingImplementation(BoundSignature boundSignature) {
        Signature signature = boundSignature.toSignature();
        Optional<Object> foundImplementation = Optional.empty();
        if (this.implementations.getExactImplementations().containsKey(signature)) {
            foundImplementation = Optional.of(this.implementations.getExactImplementations().get(signature));
        } else {
            for (AggregationImplementation candidate : this.implementations.getGenericImplementations()) {
                if (!candidate.areTypesAssignable(boundSignature)) continue;
                if (foundImplementation.isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, String.format("Ambiguous function call (%s) for %s", boundSignature, this.getFunctionMetadata().getSignature()));
                }
                foundImplementation = Optional.of(candidate);
            }
        }
        if (foundImplementation.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported type parameters (%s) for %s", boundSignature, this.getFunctionMetadata().getSignature()));
        }
        return (AggregationImplementation)foundImplementation.get();
    }

    private static List<TypeSignature> signaturesFromTypes(List<Type> types) {
        return (List)types.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
    }

    private static List<AggregationMetadata.ParameterMetadata> buildParameterMetadata(List<AggregationMetadata.ParameterMetadata.ParameterType> parameterMetadataTypes, List<Type> inputTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int inputId = 0;
        for (AggregationMetadata.ParameterMetadata.ParameterType parameterMetadataType : parameterMetadataTypes) {
            switch (parameterMetadataType) {
                case STATE: 
                case BLOCK_INDEX: {
                    builder.add((Object)new AggregationMetadata.ParameterMetadata(parameterMetadataType));
                    break;
                }
                case INPUT_CHANNEL: 
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    builder.add((Object)new AggregationMetadata.ParameterMetadata(parameterMetadataType, inputTypes.get(inputId++)));
                }
            }
        }
        return builder.build();
    }
}

