/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.stats.QuantileDigest;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.aggregation.AccumulatorCompiler;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.FloatingPointBitsConverterUtil;
import io.prestosql.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.state.QuantileDigestState;
import io.prestosql.operator.aggregation.state.QuantileDigestStateFactory;
import io.prestosql.operator.aggregation.state.QuantileDigestStateSerializer;
import io.prestosql.operator.scalar.QuantileDigestFunctions;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.QuantileDigestType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class QuantileDigestAggregationFunction
extends SqlAggregationFunction {
    public static final QuantileDigestAggregationFunction QDIGEST_AGG = new QuantileDigestAggregationFunction(new TypeSignature("V", new TypeSignatureParameter[0]));
    public static final QuantileDigestAggregationFunction QDIGEST_AGG_WITH_WEIGHT = new QuantileDigestAggregationFunction(new TypeSignature("V", new TypeSignatureParameter[0]), BigintType.BIGINT.getTypeSignature());
    public static final QuantileDigestAggregationFunction QDIGEST_AGG_WITH_WEIGHT_AND_ERROR = new QuantileDigestAggregationFunction(new TypeSignature("V", new TypeSignatureParameter[0]), BigintType.BIGINT.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature());
    public static final String NAME = "qdigest_agg";
    private static final MethodHandle INPUT_DOUBLE = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "inputDouble", QuantileDigestState.class, Double.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle INPUT_REAL = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "inputReal", QuantileDigestState.class, Long.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle INPUT_BIGINT = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "inputBigint", QuantileDigestState.class, Long.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "combineState", QuantileDigestState.class, QuantileDigestState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "evaluateFinal", QuantileDigestStateSerializer.class, QuantileDigestState.class, BlockBuilder.class);

    private QuantileDigestAggregationFunction(TypeSignature ... typeSignatures) {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parametricType((String)"qdigest", (TypeSignature[])new TypeSignature[]{new TypeSignature("V", new TypeSignatureParameter[0])}), (List<TypeSignature>)ImmutableList.copyOf((Object[])typeSignatures), false), true, Collections.nCopies(typeSignatures.length, new FunctionArgumentDefinition(false)), false, true, "Returns a qdigest from the set of reals, bigints or doubles", FunctionKind.AGGREGATE), true, true);
    }

    @Override
    public List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        Type valueType = functionBinding.getTypeVariable("V");
        return ImmutableList.of((Object)new QuantileDigestType(valueType).getTypeSignature());
    }

    @Override
    public InternalAggregationFunction specialize(FunctionBinding functionBinding) {
        Type valueType = functionBinding.getTypeVariable("V");
        QuantileDigestType outputType = (QuantileDigestType)functionBinding.getBoundSignature().getReturnType();
        return QuantileDigestAggregationFunction.generateAggregation(valueType, outputType, functionBinding.getArity());
    }

    private static InternalAggregationFunction generateAggregation(Type valueType, QuantileDigestType outputType, int arity) {
        DynamicClassLoader classLoader = new DynamicClassLoader(QuantileDigestAggregationFunction.class.getClassLoader());
        List<Type> inputTypes = QuantileDigestAggregationFunction.getInputTypes(valueType, arity);
        QuantileDigestStateSerializer stateSerializer = new QuantileDigestStateSerializer(valueType);
        Type intermediateType = stateSerializer.getSerializedType();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), QuantileDigestAggregationFunction.createInputParameterMetadata(inputTypes), QuantileDigestAggregationFunction.getMethodHandle(valueType, arity), Optional.empty(), COMBINE_FUNCTION, OUTPUT_FUNCTION.bindTo(stateSerializer), (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(QuantileDigestState.class, stateSerializer, new QuantileDigestStateFactory())), (Type)outputType);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), (Type)outputType, factory);
    }

    private static List<Type> getInputTypes(Type valueType, int arity) {
        switch (arity) {
            case 1: {
                return ImmutableList.of((Object)valueType);
            }
            case 2: {
                return ImmutableList.of((Object)valueType, (Object)BigintType.BIGINT);
            }
            case 3: {
                return ImmutableList.of((Object)valueType, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported number of arguments: %s", arity));
    }

    private static MethodHandle getMethodHandle(Type valueType, int arity) {
        MethodHandle inputFunction;
        switch (valueType.getDisplayName()) {
            case "double": {
                inputFunction = INPUT_DOUBLE;
                break;
            }
            case "real": {
                inputFunction = INPUT_REAL;
                break;
            }
            case "bigint": {
                inputFunction = INPUT_BIGINT;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported type %s supplied", valueType.getDisplayName()));
            }
        }
        switch (arity) {
            case 1: {
                return MethodHandles.insertArguments(inputFunction, 2, 1L, 0.01);
            }
            case 2: {
                return MethodHandles.insertArguments(inputFunction, 3, 0.01);
            }
            case 3: {
                return inputFunction;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported number of arguments: %s", arity));
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(List<Type> valueTypes) {
        return ImmutableList.builder().add((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE)).addAll((Iterable)valueTypes.stream().map(valueType -> new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Type)valueType)).collect(Collectors.toList())).build();
    }

    public static void inputDouble(QuantileDigestState state, double value, long weight, double accuracy) {
        QuantileDigestAggregationFunction.inputBigint(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, accuracy);
    }

    public static void inputReal(QuantileDigestState state, long value, long weight, double accuracy) {
        QuantileDigestAggregationFunction.inputBigint(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), weight, accuracy);
    }

    public static void inputBigint(QuantileDigestState state, long value, long weight, double accuracy) {
        QuantileDigest qdigest = QuantileDigestAggregationFunction.getOrCreateQuantileDigest(state, QuantileDigestFunctions.verifyAccuracy(accuracy));
        state.addMemoryUsage(-qdigest.estimatedInMemorySizeInBytes());
        qdigest.add(value, QuantileDigestFunctions.verifyWeight(weight));
        state.addMemoryUsage(qdigest.estimatedInMemorySizeInBytes());
    }

    private static QuantileDigest getOrCreateQuantileDigest(QuantileDigestState state, double accuracy) {
        QuantileDigest qdigest = state.getQuantileDigest();
        if (qdigest == null) {
            qdigest = new QuantileDigest(accuracy);
            state.setQuantileDigest(qdigest);
            state.addMemoryUsage(qdigest.estimatedInMemorySizeInBytes());
        }
        return qdigest;
    }

    public static void combineState(QuantileDigestState state, QuantileDigestState otherState) {
        QuantileDigest input = otherState.getQuantileDigest();
        QuantileDigest previous = state.getQuantileDigest();
        if (previous == null) {
            state.setQuantileDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    public static void evaluateFinal(QuantileDigestStateSerializer serializer, QuantileDigestState state, BlockBuilder out) {
        serializer.serialize(state, out);
    }
}

