/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.DoubleHistogramAggregation;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.RealType;
import java.util.Map;

@AggregationFunction(value="numeric_histogram")
public final class RealHistogramAggregation {
    private RealHistogramAggregation() {
    }

    @InputFunction
    public static void add(@AggregationState DoubleHistogramAggregation.State state, @SqlType(value="bigint") long buckets, @SqlType(value="real") long value, @SqlType(value="double") double weight) {
        DoubleHistogramAggregation.add(state, buckets, Float.intBitsToFloat((int)value), weight);
    }

    @InputFunction
    public static void add(@AggregationState DoubleHistogramAggregation.State state, @SqlType(value="bigint") long buckets, @SqlType(value="real") long value) {
        RealHistogramAggregation.add(state, buckets, value, 1.0);
    }

    @CombineFunction
    public static void merge(@AggregationState DoubleHistogramAggregation.State state, @AggregationState DoubleHistogramAggregation.State other) {
        DoubleHistogramAggregation.merge(state, other);
    }

    @OutputFunction(value="map(real,real)")
    public static void output(@AggregationState DoubleHistogramAggregation.State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            Map<Double, Double> value = state.get().getBuckets();
            BlockBuilder entryBuilder = out.beginBlockEntry();
            for (Map.Entry<Double, Double> entry : value.entrySet()) {
                RealType.REAL.writeLong(entryBuilder, (long)Float.floatToRawIntBits(entry.getKey().floatValue()));
                RealType.REAL.writeLong(entryBuilder, (long)Float.floatToRawIntBits(entry.getValue().floatValue()));
            }
            out.closeEntry();
        }
    }
}

