/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.histogram;

import io.prestosql.operator.aggregation.histogram.GroupedHistogramState;
import io.prestosql.operator.aggregation.histogram.HistogramState;
import io.prestosql.operator.aggregation.histogram.SingleHistogramState;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.type.Type;
import io.prestosql.type.BlockTypeOperators;
import java.util.Objects;

public class HistogramStateFactory
implements AccumulatorStateFactory<HistogramState> {
    private final Type keyType;
    private final BlockTypeOperators.BlockPositionEqual equalOperator;
    private final BlockTypeOperators.BlockPositionHashCode hashCodeOperator;
    private final int expectedEntriesCount;

    public HistogramStateFactory(Type keyType, BlockTypeOperators.BlockPositionEqual equalOperator, BlockTypeOperators.BlockPositionHashCode hashCodeOperator, int expectedEntriesCount) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.equalOperator = Objects.requireNonNull(equalOperator, "equalOperator is null");
        this.hashCodeOperator = Objects.requireNonNull(hashCodeOperator, "hashCodeOperator is null");
        this.expectedEntriesCount = expectedEntriesCount;
    }

    public HistogramState createSingleState() {
        return new SingleHistogramState(this.keyType, this.equalOperator, this.hashCodeOperator, this.expectedEntriesCount);
    }

    public Class<? extends HistogramState> getSingleStateClass() {
        return SingleHistogramState.class;
    }

    public HistogramState createGroupedState() {
        return new GroupedHistogramState(this.keyType, this.equalOperator, this.hashCodeOperator, this.expectedEntriesCount);
    }

    public Class<? extends HistogramState> getGroupedStateClass() {
        return GroupedHistogramState.class;
    }
}

