/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.histogram;

import com.google.common.base.Preconditions;
import io.prestosql.array.IntBigArray;
import io.prestosql.array.LongBigArray;
import io.prestosql.operator.aggregation.histogram.HistogramValueReader;
import io.prestosql.operator.aggregation.histogram.TypedHistogram;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SingleTypedHistogram
implements TypedHistogram {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleTypedHistogram.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private final int expectedSize;
    private int hashCapacity;
    private int maxFill;
    private int mask;
    private final Type type;
    private final BlockTypeOperators.BlockPositionEqual equalOperator;
    private final BlockTypeOperators.BlockPositionHashCode hashCodeOperator;
    private final BlockBuilder values;
    private IntBigArray hashPositions;
    private final LongBigArray counts;

    private SingleTypedHistogram(Type type, BlockTypeOperators.BlockPositionEqual equalOperator, BlockTypeOperators.BlockPositionHashCode hashCodeOperator, int expectedSize, int hashCapacity, BlockBuilder values) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.equalOperator = Objects.requireNonNull(equalOperator, "equalOperator is null");
        this.hashCodeOperator = Objects.requireNonNull(hashCodeOperator, "hashCodeOperator is null");
        this.expectedSize = expectedSize;
        this.hashCapacity = hashCapacity;
        this.values = values;
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        this.maxFill = SingleTypedHistogram.calculateMaxFill(hashCapacity);
        this.mask = hashCapacity - 1;
        this.hashPositions = new IntBigArray(-1);
        this.hashPositions.ensureCapacity((long)hashCapacity);
        this.counts = new LongBigArray();
        this.counts.ensureCapacity((long)hashCapacity);
    }

    public SingleTypedHistogram(Type type, BlockTypeOperators.BlockPositionEqual equalOperator, BlockTypeOperators.BlockPositionHashCode hashCodeOperator, int expectedSize) {
        this(type, equalOperator, hashCodeOperator, expectedSize, SingleTypedHistogram.computeBucketCount(expectedSize), type.createBlockBuilder(null, SingleTypedHistogram.computeBucketCount(expectedSize)));
    }

    private static int computeBucketCount(int expectedSize) {
        return HashCommon.arraySize((int)expectedSize, (float)0.75f);
    }

    public SingleTypedHistogram(Block block, Type type, BlockTypeOperators.BlockPositionEqual equalOperator, BlockTypeOperators.BlockPositionHashCode hashCodeOperator, int expectedSize) {
        this(type, equalOperator, hashCodeOperator, expectedSize);
        Objects.requireNonNull(block, "block is null");
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            this.add(i, block, BigintType.BIGINT.getLong(block, i + 1));
        }
    }

    @Override
    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.values.getRetainedSizeInBytes() + this.counts.sizeOf() + this.hashPositions.sizeOf();
    }

    @Override
    public void serialize(BlockBuilder out) {
        if (this.values.getPositionCount() == 0) {
            out.appendNull();
        } else {
            Block valuesBlock = this.values.build();
            BlockBuilder blockBuilder = out.beginBlockEntry();
            for (int i = 0; i < valuesBlock.getPositionCount(); ++i) {
                this.type.appendTo(valuesBlock, i, blockBuilder);
                BigintType.BIGINT.writeLong(blockBuilder, this.counts.get((long)i));
            }
            out.closeEntry();
        }
    }

    @Override
    public void addAll(TypedHistogram other) {
        other.readAllValues((block, position, count) -> this.add(position, block, count));
    }

    @Override
    public void readAllValues(HistogramValueReader reader) {
        for (int i = 0; i < this.values.getPositionCount(); ++i) {
            long count = this.counts.get((long)i);
            if (count <= 0L) continue;
            reader.read((Block)this.values, i, count);
        }
    }

    @Override
    public void add(int position, Block block, long count) {
        int hashPosition = SingleTypedHistogram.getBucketId(this.hashCodeOperator.hashCodeNullSafe(block, position), this.mask);
        while (this.hashPositions.get((long)hashPosition) != -1) {
            if (this.equalOperator.equal(block, position, (Block)this.values, this.hashPositions.get((long)hashPosition)).booleanValue()) {
                this.counts.add((long)this.hashPositions.get((long)hashPosition), count);
                return;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        this.addNewGroup(hashPosition, position, block, count);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getExpectedSize() {
        return this.expectedSize;
    }

    @Override
    public boolean isEmpty() {
        return this.values.getPositionCount() == 0;
    }

    private void addNewGroup(int hashPosition, int position, Block block, long count) {
        this.hashPositions.set((long)hashPosition, this.values.getPositionCount());
        this.counts.set((long)this.values.getPositionCount(), count);
        this.type.appendTo(block, position, this.values);
        if (this.values.getPositionCount() >= this.maxFill) {
            this.rehash();
        }
    }

    private void rehash() {
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        int newCapacity = (int)newCapacityLong;
        int newMask = newCapacity - 1;
        IntBigArray newHashPositions = new IntBigArray(-1);
        newHashPositions.ensureCapacity((long)newCapacity);
        for (int i = 0; i < this.values.getPositionCount(); ++i) {
            int hashPosition = SingleTypedHistogram.getBucketId(this.hashCodeOperator.hashCodeNullSafe((Block)this.values, i), newMask);
            while (newHashPositions.get((long)hashPosition) != -1) {
                hashPosition = hashPosition + 1 & newMask;
            }
            newHashPositions.set((long)hashPosition, i);
        }
        this.hashCapacity = newCapacity;
        this.mask = newMask;
        this.maxFill = SingleTypedHistogram.calculateMaxFill(newCapacity);
        this.hashPositions = newHashPositions;
        this.counts.ensureCapacity((long)this.maxFill);
    }

    private static int getBucketId(long rawHash, int mask) {
        return (int)HashCommon.murmurHash3((long)rawHash) & mask;
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }
}

