/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import io.airlift.stats.TDigest;
import io.prestosql.array.DoubleBigArray;
import io.prestosql.array.ObjectBigArray;
import io.prestosql.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.prestosql.operator.aggregation.state.TDigestAndPercentileState;
import io.prestosql.spi.function.AccumulatorStateFactory;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class TDigestAndPercentileStateFactory
implements AccumulatorStateFactory<TDigestAndPercentileState> {
    public TDigestAndPercentileState createSingleState() {
        return new SingleTDigestAndPercentileState();
    }

    public Class<? extends TDigestAndPercentileState> getSingleStateClass() {
        return SingleTDigestAndPercentileState.class;
    }

    public TDigestAndPercentileState createGroupedState() {
        return new GroupedTDigestAndPercentileState();
    }

    public Class<? extends TDigestAndPercentileState> getGroupedStateClass() {
        return GroupedTDigestAndPercentileState.class;
    }

    public static class SingleTDigestAndPercentileState
    implements TDigestAndPercentileState {
        public static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleTDigestAndPercentileState.class).instanceSize();
        private TDigest digest;
        private double percentile;

        @Override
        public TDigest getDigest() {
            return this.digest;
        }

        @Override
        public void setDigest(TDigest digest) {
            this.digest = digest;
        }

        @Override
        public double getPercentile() {
            return this.percentile;
        }

        @Override
        public void setPercentile(double percentile) {
            this.percentile = percentile;
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.digest != null) {
                estimatedSize += (long)this.digest.estimatedInMemorySizeInBytes();
            }
            return estimatedSize;
        }
    }

    public static class GroupedTDigestAndPercentileState
    extends AbstractGroupedAccumulatorState
    implements TDigestAndPercentileState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedTDigestAndPercentileState.class).instanceSize();
        private final ObjectBigArray<TDigest> digests = new ObjectBigArray();
        private final DoubleBigArray percentiles = new DoubleBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.digests.ensureCapacity(size);
            this.percentiles.ensureCapacity(size);
        }

        @Override
        public TDigest getDigest() {
            return (TDigest)this.digests.get(this.getGroupId());
        }

        @Override
        public void setDigest(TDigest digest) {
            Objects.requireNonNull(digest, "value is null");
            this.digests.set(this.getGroupId(), (Object)digest);
        }

        @Override
        public double getPercentile() {
            return this.percentiles.get(this.getGroupId());
        }

        @Override
        public void setPercentile(double percentile) {
            this.percentiles.set(this.getGroupId(), percentile);
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.digests.sizeOf() + this.percentiles.sizeOf();
        }
    }
}

