/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.exchange;

import com.google.common.base.Preconditions;
import io.prestosql.spi.Page;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;

public class PageChannelSelector
implements Function<Page, Page> {
    private final int[] channels;

    public PageChannelSelector(int ... channels) {
        this.channels = (int[])Objects.requireNonNull(channels, "channels is null").clone();
        Preconditions.checkArgument((boolean)IntStream.of(channels).allMatch(channel -> channel >= 0), (Object)"channels must be positive");
    }

    @Override
    public Page apply(Page page) {
        return Objects.requireNonNull(page, "page is null").getColumns(this.channels);
    }
}

