/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.exchange;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.operator.HashGenerator;
import io.prestosql.operator.InterpretedHashGenerator;
import io.prestosql.operator.PrecomputedHashGenerator;
import io.prestosql.operator.exchange.LocalExchangeMemoryManager;
import io.prestosql.operator.exchange.LocalExchanger;
import io.prestosql.operator.exchange.LocalPartitionGenerator;
import io.prestosql.operator.exchange.PageReference;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.Type;
import io.prestosql.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

class PartitioningExchanger
implements LocalExchanger {
    private final List<Consumer<PageReference>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final LocalPartitionGenerator partitionGenerator;
    private final IntArrayList[] partitionAssignments;

    public PartitioningExchanger(List<Consumer<PageReference>> partitions, LocalExchangeMemoryManager memoryManager, List<? extends Type> types, List<Integer> partitionChannels, Optional<Integer> hashChannel, BlockTypeOperators blockTypeOperators) {
        HashGenerator hashGenerator;
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitions, "partitions is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        if (hashChannel.isPresent()) {
            hashGenerator = new PrecomputedHashGenerator(hashChannel.get());
        } else {
            List partitionChannelTypes = (List)partitionChannels.stream().map(types::get).collect(ImmutableList.toImmutableList());
            hashGenerator = new InterpretedHashGenerator((List<Type>)partitionChannelTypes, Ints.toArray(partitionChannels), blockTypeOperators);
        }
        this.partitionGenerator = new LocalPartitionGenerator(hashGenerator, this.buffers.size());
        this.partitionAssignments = new IntArrayList[partitions.size()];
        for (int i = 0; i < this.partitionAssignments.length; ++i) {
            this.partitionAssignments[i] = new IntArrayList();
        }
    }

    @Override
    public synchronized void accept(Page page) {
        for (IntArrayList partitionAssignment : this.partitionAssignments) {
            partitionAssignment.clear();
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int partition = this.partitionGenerator.getPartition(page, position);
            this.partitionAssignments[partition].add(position);
        }
        for (int partition = 0; partition < this.buffers.size(); ++partition) {
            IntArrayList positions = this.partitionAssignments[partition];
            if (positions.isEmpty()) continue;
            Page pageSplit = page.copyPositions(positions.elements(), 0, positions.size());
            this.memoryManager.updateMemoryUsage(pageSplit.getRetainedSizeInBytes());
            this.buffers.get(partition).accept(new PageReference(pageSplit, 1, () -> this.memoryManager.updateMemoryUsage(-pageSplit.getRetainedSizeInBytes())));
        }
    }

    @Override
    public ListenableFuture<?> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

