/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.scalar.BooleanToBooleanFunction;
import io.prestosql.operator.scalar.DoubleToBooleanFunction;
import io.prestosql.operator.scalar.LongToBooleanFunction;
import io.prestosql.operator.scalar.ObjectToBooleanFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameterSpecialization;
import io.prestosql.spi.type.Type;

@Description(value="Return array containing elements that match the given predicate")
@ScalarFunction(value="filter", deterministic=false)
public final class ArrayFilterFunction {
    private ArrayFilterFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="array(T)")
    public static Block filterLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") LongToBooleanFunction function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Long input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getLong(arrayBlock, position);
            }
            if (!Boolean.TRUE.equals(keep = function.apply(input))) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="array(T)")
    public static Block filterDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") DoubleToBooleanFunction function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Double input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getDouble(arrayBlock, position);
            }
            if (!Boolean.TRUE.equals(keep = function.apply(input))) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="array(T)")
    public static Block filterBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BooleanToBooleanFunction function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Boolean input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getBoolean(arrayBlock, position);
            }
            if (!Boolean.TRUE.equals(keep = function.apply(input))) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Object.class)
    @SqlType(value="array(T)")
    public static Block filterObject(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") ObjectToBooleanFunction function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Object input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getObject(arrayBlock, position);
            }
            if (!Boolean.TRUE.equals(keep = function.apply(input))) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }
}

