/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_min")
@Description(value="Get minimum value of array")
public final class ArrayMinFunction {
    private ArrayMinFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Long longArrayMin(@OperatorDependency(operator=OperatorType.COMPARISON, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        int selectedPosition = ArrayMinFunction.findMinArrayElement(compareMethodHandle, block);
        if (selectedPosition < 0) {
            return null;
        }
        return elementType.getLong(block, selectedPosition);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Boolean booleanArrayMin(@OperatorDependency(operator=OperatorType.COMPARISON, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        int selectedPosition = ArrayMinFunction.findMinArrayElement(compareMethodHandle, block);
        if (selectedPosition < 0) {
            return null;
        }
        return elementType.getBoolean(block, selectedPosition);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Double doubleArrayMin(@OperatorDependency(operator=OperatorType.COMPARISON, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        int selectedPosition = ArrayMinFunction.findMinArrayElement(compareMethodHandle, block);
        if (selectedPosition < 0) {
            return null;
        }
        return elementType.getDouble(block, selectedPosition);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Object objectArrayMin(@OperatorDependency(operator=OperatorType.COMPARISON, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        int selectedPosition = ArrayMinFunction.findMinArrayElement(compareMethodHandle, block);
        if (selectedPosition < 0) {
            return null;
        }
        return elementType.getObject(block, selectedPosition);
    }

    private static int findMinArrayElement(MethodHandle compareMethodHandle, Block block) {
        try {
            int selectedPosition = -1;
            for (int position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) {
                    return -1;
                }
                if (selectedPosition >= 0 && compareMethodHandle.invokeExact(block, position, block, selectedPosition) >= 0L) continue;
                selectedPosition = position;
            }
            return selectedPosition;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

