/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;

public class ArraySubscriptOperator
extends SqlOperator {
    public static final ArraySubscriptOperator ARRAY_SUBSCRIPT = new ArraySubscriptOperator();
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(ArraySubscriptOperator.class, "booleanSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(ArraySubscriptOperator.class, "longSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(ArraySubscriptOperator.class, "doubleSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(ArraySubscriptOperator.class, "sliceSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(ArraySubscriptOperator.class, "objectSubscript", Type.class, Block.class, Long.TYPE);

    protected ArraySubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("E", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])), (Object)BigintType.BIGINT.getTypeSignature()), true);
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Type elementType = functionBinding.getTypeVariable("E");
        MethodHandle methodHandle = elementType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (elementType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (elementType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (elementType.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        methodHandle = methodHandle.bindTo(elementType);
        Objects.requireNonNull(methodHandle, "methodHandle is null");
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Long longSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getLong(array, position);
    }

    @UsedByGeneratedCode
    public static Boolean booleanSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getBoolean(array, position);
    }

    @UsedByGeneratedCode
    public static Double doubleSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getDouble(array, position);
    }

    @UsedByGeneratedCode
    public static Slice sliceSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getSlice(array, position);
    }

    @UsedByGeneratedCode
    public static Object objectSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getObject(array, position);
    }

    public static void checkArrayIndex(long index) {
        if (index == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (index < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript is negative: " + index);
        }
    }

    public static void checkIndex(Block array, long index) {
        ArraySubscriptOperator.checkArrayIndex(index);
        if (index > (long)array.getPositionCount()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Array subscript must be less than or equal to array length: %s > %s", index, array.getPositionCount()));
        }
    }
}

