/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;

public final class ConcatWsFunction
extends SqlScalarFunction {
    public static final ConcatWsFunction CONCAT_WS = new ConcatWsFunction();
    private static final int MAX_INPUT_VALUES = 254;
    private static final int MAX_OUTPUT_LENGTH = 0x100000;

    public ConcatWsFunction() {
        super(new FunctionMetadata(new Signature("concat_ws", (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), VarcharType.VARCHAR.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)VarcharType.VARCHAR.getTypeSignature(), (Object)VarcharType.VARCHAR.getTypeSignature()), true), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(true)), false, true, "Concatenates elements using separator", FunctionKind.SCALAR));
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding binding) {
        int valueCount = binding.getArity() - 1;
        if (valueCount < 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more arguments");
        }
        MethodHandle arrayMethodHandle = Reflection.methodHandle(ConcatWsFunction.class, "concatWs", Slice.class, Slice[].class);
        MethodHandle customMethodHandle = arrayMethodHandle.asCollector(Slice[].class, valueCount);
        return new ChoicesScalarFunctionImplementation(binding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.builder().add((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL).addAll(Collections.nCopies(valueCount, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE)).build(), customMethodHandle);
    }

    @UsedByGeneratedCode
    public static Slice concatWs(Slice separator, final Slice[] values) {
        return ConcatWsFunction.concatWs(separator, new SliceArray(){

            @Override
            public Slice getElement(int i) {
                return values[i];
            }

            @Override
            public int getCount() {
                return values.length;
            }
        });
    }

    private static Slice concatWs(Slice separator, SliceArray values) {
        if (values.getCount() > 254) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for string concatenation");
        }
        int length = 0;
        boolean requiresSeparator = false;
        for (int i = 0; i < values.getCount(); ++i) {
            Slice value = values.getElement(i);
            if (value == null) continue;
            if (requiresSeparator) {
                length = Math.addExact(length, separator.length());
            }
            length = Math.addExact(length, value.length());
            requiresSeparator = true;
            if (length <= 0x100000) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Concatenated string is too large");
        }
        Slice result = Slices.allocate((int)length);
        int position = 0;
        requiresSeparator = false;
        for (int i = 0; i < values.getCount(); ++i) {
            Slice value = values.getElement(i);
            if (value == null) continue;
            if (requiresSeparator) {
                result.setBytes(position, separator);
                position += separator.length();
            }
            result.setBytes(position, value);
            position += value.length();
            requiresSeparator = true;
        }
        return result;
    }

    private static interface SliceArray {
        public Slice getElement(int var1);

        public int getCount();
    }

    @ScalarFunction(value="concat_ws")
    public static final class ConcatArrayWs {
        @SqlType(value="varchar")
        public static Slice concatWsArray(@SqlType(value="varchar") Slice separator, final @SqlType(value="array(varchar)") Block elements) {
            return ConcatWsFunction.concatWs(separator, new SliceArray(){

                @Override
                public Slice getElement(int i) {
                    if (elements.isNull(i)) {
                        return null;
                    }
                    int sliceLength = elements.getSliceLength(i);
                    return elements.getSlice(i, 0, sliceLength);
                }

                @Override
                public int getCount() {
                    return elements.getPositionCount();
                }
            });
        }
    }
}

