/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.Decimals;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class DataSizeFunctions {
    private DataSizeFunctions() {
    }

    @Description(value="Converts data size string to bytes")
    @ScalarFunction(value="parse_presto_data_size")
    @LiteralParameters(value={"x"})
    @SqlType(value="decimal(38,0)")
    public static Slice parsePrestoDataSize(@SqlType(value="varchar(x)") Slice input) {
        char c;
        String dataSize = input.toStringUtf8();
        int valueLength = 0;
        for (int i = 0; i < dataSize.length() && (Character.isDigit(c = dataSize.charAt(i)) || c == '.'); ++i) {
            ++valueLength;
        }
        if (valueLength == 0) {
            throw DataSizeFunctions.invalidDataSize(dataSize);
        }
        BigDecimal value = DataSizeFunctions.parseValue(dataSize.substring(0, valueLength), dataSize);
        Unit unit = Unit.parse(dataSize.substring(valueLength), dataSize);
        BigInteger bytes = value.multiply(unit.getFactor()).toBigInteger();
        try {
            return Decimals.encodeUnscaledValue((BigInteger)bytes);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("Value out of range: '%s' ('%sB')", dataSize, bytes));
        }
    }

    private static BigDecimal parseValue(String value, String dataSize) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw DataSizeFunctions.invalidDataSize(dataSize);
        }
    }

    private static PrestoException invalidDataSize(String dataSize) {
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid data size: '%s'", dataSize));
    }

    private static enum Unit {
        BYTE(BigDecimal.ONE),
        KILOBYTE(new BigDecimal(1024L)),
        MEGABYTE(new BigDecimal(0x100000L)),
        GIGABYTE(new BigDecimal(0x40000000L)),
        TERABYTE(new BigDecimal(0x10000000000L)),
        PETABYTE(new BigDecimal(0x4000000000000L)),
        EXABYTE(new BigDecimal(0x1000000000000000L)),
        ZETTABYTE(new BigDecimal(0x1000000000000000L).multiply(new BigDecimal(1024L))),
        YOTTABYTE(new BigDecimal(0x1000000000000000L).multiply(new BigDecimal(0x100000L)));

        private final BigDecimal factor;

        private Unit(BigDecimal factor) {
            this.factor = factor;
        }

        public BigDecimal getFactor() {
            return this.factor;
        }

        public static Unit parse(String unitString, String dataSize) {
            switch (unitString) {
                case "B": {
                    return BYTE;
                }
                case "kB": {
                    return KILOBYTE;
                }
                case "MB": {
                    return MEGABYTE;
                }
                case "GB": {
                    return GIGABYTE;
                }
                case "TB": {
                    return TERABYTE;
                }
                case "PB": {
                    return PETABYTE;
                }
                case "EB": {
                    return EXABYTE;
                }
                case "ZB": {
                    return ZETTABYTE;
                }
                case "YB": {
                    return YOTTABYTE;
                }
            }
            throw DataSizeFunctions.invalidDataSize(dataSize);
        }
    }
}

