/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.util.Failures;

public final class LuhnCheckFunction {
    private LuhnCheckFunction() {
    }

    @Description(value="Checks that a string of digits is valid according to the Luhn algorithm")
    @ScalarFunction(value="luhn_check")
    @SqlType(value="boolean")
    public static boolean LuhnCheck(@SqlType(value="varchar") Slice slice) {
        if (slice.length() == 0) {
            return false;
        }
        int nDigits = slice.length();
        int sum = 0;
        boolean secondNumber = false;
        for (int i = nDigits - 1; i >= 0; --i) {
            byte b = slice.getByte(i);
            Failures.checkCondition(b >= 48 && b <= 57, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Input contains non-digit character", new Object[0]);
            int n = b - 48;
            if (secondNumber) {
                n *= 2;
            }
            if (n > 9) {
                n -= 9;
            }
            sum += n;
            secondNumber = !secondNumber;
        }
        return sum % 10 == 0;
    }
}

