/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.TypedSet;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameters;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.type.BlockTypeOperators;
import java.util.List;

@ScalarFunction(value="map_from_entries")
@Description(value="Construct a map from an array of entries")
public final class MapFromEntriesFunction {
    private final PageBuilder pageBuilder;

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public MapFromEntriesFunction(@TypeParameter(value="map(K,V)") Type mapType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="map(K,V)")
    @SqlNullable
    public Block mapFromEntries(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) BlockTypeOperators.BlockPositionEqual keyEqual, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode keyHashCode, @TypeParameter(value="map(K,V)") MapType mapType, ConnectorSession session, @SqlType(value="array(row(K,V))") Block block) {
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)keyType, (Object)valueType));
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        int entryCount = block.getPositionCount();
        BlockBuilder mapBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        BlockBuilder resultBuilder = mapBlockBuilder.beginBlockEntry();
        TypedSet uniqueKeys = TypedSet.createEqualityTypedSet(keyType, keyEqual, keyHashCode, entryCount, "map_from_entries");
        for (int i = 0; i < entryCount; ++i) {
            if (block.isNull(i)) {
                mapBlockBuilder.closeEntry();
                this.pageBuilder.declarePosition();
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map entry cannot be null");
            }
            Block rowBlock = rowType.getObject(block, i);
            if (rowBlock.isNull(0)) {
                mapBlockBuilder.closeEntry();
                this.pageBuilder.declarePosition();
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            if (uniqueKeys.contains(rowBlock, 0)) {
                mapBlockBuilder.closeEntry();
                this.pageBuilder.declarePosition();
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Duplicate keys (%s) are not allowed", keyType.getObjectValue(session, rowBlock, 0)));
            }
            uniqueKeys.add(rowBlock, 0);
            keyType.appendTo(rowBlock, 0, resultBuilder);
            valueType.appendTo(rowBlock, 1, resultBuilder);
        }
        mapBlockBuilder.closeEntry();
        this.pageBuilder.declarePosition();
        return mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }
}

