/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameters;
import io.prestosql.spi.type.Type;

@ScalarFunction(value="map_keys")
@Description(value="Returns the keys of the given map(K,V) as an array")
public final class MapKeys {
    private MapKeys() {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="array(K)")
    public static Block getKeys(@TypeParameter(value="K") Type keyType, @SqlType(value="map(K,V)") Block block) {
        BlockBuilder blockBuilder = keyType.createBlockBuilder(null, block.getPositionCount() / 2);
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            keyType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }
}

