/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.time;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.type.DateTimes;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeToTimeWithTimeZoneCast {
    private TimeToTimeWithTimeZoneCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static long castToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision)") long time) {
        long picos = DateTimes.round(time, (int)(12L - targetPrecision));
        long nanos = DateTimes.rescale(picos, 12, 9) % 86400000000000L;
        return DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)DateTimes.getOffsetMinutes(session.getStart(), session.getTimeZoneKey()));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static LongTimeWithTimeZone castToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision)") long time) {
        long picos = DateTimes.round(time, (int)(12L - targetPrecision)) % 86400000000000000L;
        return new LongTimeWithTimeZone(picos, DateTimes.getOffsetMinutes(session.getStart(), session.getTimeZoneKey()));
    }
}

