/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.time;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;
import java.time.LocalDate;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeToTimestampCast {
    private TimeToTimestampCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long castToShort(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision)") long time) {
        long epochSeconds = TimeToTimestampCast.getEpochSeconds(session, time);
        long picoFraction = TimeToTimestampCast.getPicoFraction(sourcePrecision, targetPrecision, time);
        return TimeToTimestampCast.computeEpochMicros(epochSeconds, picoFraction);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp castToLong(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision)") long time) {
        long epochSeconds = TimeToTimestampCast.getEpochSeconds(session, time);
        long picoFraction = TimeToTimestampCast.getPicoFraction(sourcePrecision, targetPrecision, time);
        long epochMicros = TimeToTimestampCast.computeEpochMicros(epochSeconds, picoFraction);
        int picosOfMicro = (int)(picoFraction % 1000000L);
        return new LongTimestamp(epochMicros, picosOfMicro);
    }

    private static long getEpochSeconds(ConnectorSession session, long time) {
        long epochDay = LocalDate.ofInstant(session.getStart(), session.getTimeZoneKey().getZoneId()).toEpochDay();
        return Math.multiplyExact(epochDay, 86400L) + time / 1000000000000L;
    }

    private static long getPicoFraction(long sourcePrecision, long targetPrecision, long time) {
        long picoFraction = time % 1000000000000L;
        if (sourcePrecision > targetPrecision) {
            picoFraction = DateTimes.round(picoFraction, (int)(12L - targetPrecision));
        }
        return picoFraction;
    }

    private static long computeEpochMicros(long epochSeconds, long picoFraction) {
        long microFraction = picoFraction / 1000000L;
        return Math.multiplyExact(epochSeconds, 1000000) + microFraction;
    }
}

