/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;
import org.joda.time.chrono.ISOChronology;

@Description(value="Day of the year of the given timestamp")
@ScalarFunction(value="day_of_year", alias={"doy"})
public class ExtractDayOfYear {
    private ExtractDayOfYear() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p)") long timestamp) {
        return ISOChronology.getInstanceUTC().dayOfYear().get(DateTimes.scaleEpochMicrosToMillis(timestamp));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return ExtractDayOfYear.extract(timestamp.getEpochMicros());
    }
}

