/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

@ScalarFunction(value="$localtimestamp", hidden=true)
public final class LocalTimestamp {
    private LocalTimestamp() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static long localTimestamp(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlNullable @SqlType(value="timestamp(p)") Long dummy) {
        Instant start = LocalDateTime.ofInstant(session.getStart(), session.getTimeZoneKey().getZoneId()).toInstant(ZoneOffset.UTC);
        long epochMicros = DateTimes.epochSecondToMicrosWithRounding(start.getEpochSecond(), (long)start.getNano() * 1000L);
        return DateTimes.round(epochMicros, (int)(6L - precision));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp localTimestamp(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlNullable @SqlType(value="timestamp(p)") LongTimestamp dummy) {
        Instant start = LocalDateTime.ofInstant(session.getStart(), session.getTimeZoneKey().getZoneId()).toInstant(ZoneOffset.UTC);
        return DateTimes.longTimestamp(precision, start);
    }
}

