/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;
import java.time.LocalDate;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeWithTimeZoneToTimestampCast {
    private TimeWithTimeZoneToTimestampCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long shortToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision) with time zone") long packedTime) {
        long picos = DateTimes.rescale(DateTimeEncoding.unpackTimeNanos((long)packedTime), 9, 12);
        picos = DateTimes.round(picos, (int)(12L - targetPrecision));
        return TimeWithTimeZoneToTimestampCast.calculateEpochMicros(session, picos);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision) with time zone") LongTimeWithTimeZone time) {
        long picos = time.getPicoSeconds();
        picos = DateTimes.round(picos, (int)(12L - targetPrecision));
        return TimeWithTimeZoneToTimestampCast.calculateEpochMicros(session, picos);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp shortToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision) with time zone") long packedTime) {
        long picos = DateTimes.rescale(DateTimeEncoding.unpackTimeNanos((long)packedTime), 9, 12);
        picos = DateTimes.round(picos, (int)(12L - targetPrecision));
        long epochMicros = TimeWithTimeZoneToTimestampCast.calculateEpochMicros(session, picos);
        return new LongTimestamp(epochMicros, (int)(picos % 1000000L));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision) with time zone") LongTimeWithTimeZone time) {
        long picos = time.getPicoSeconds();
        picos = DateTimes.round(picos, (int)(12L - targetPrecision));
        long epochMicros = TimeWithTimeZoneToTimestampCast.calculateEpochMicros(session, picos);
        return new LongTimestamp(epochMicros, (int)(picos % 1000000L));
    }

    private static long calculateEpochMicros(ConnectorSession session, long picos) {
        long epochDay = LocalDate.ofInstant(session.getStart(), session.getTimeZoneKey().getZoneId()).toEpochDay();
        long epochSecond = Math.multiplyExact(epochDay, 86400L) + picos / 1000000000000L;
        long picoFraction = picos % 1000000000000L;
        return Math.multiplyExact(epochSecond, 1000000) + DateTimes.rescale(picoFraction, 12, 6);
    }
}

