/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@Description(value="Difference of the given times in the given unit")
@ScalarFunction(value="date_diff")
public class DateDiff {
    private DateDiff() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis1, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis2) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(packedEpochMillis1), unit).getDifferenceAsLong(DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis2), DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis1));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp1, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp2) {
        long epochMillis1 = timestamp1.getEpochMillis();
        long epochMillis2 = timestamp2.getEpochMillis();
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        return DateTimeFunctions.getTimestampField(chronology, unit).getDifferenceAsLong(epochMillis2, epochMillis1);
    }
}

