/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.DateTimes;
import io.prestosql.util.DateTimeZoneIndex;

@ScalarFunction
@Description(value="Formats the given timestamp by the given format")
public class DateFormat {
    private DateFormat() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="varchar(x)") Slice formatString) {
        return DateTimeFunctions.dateFormat(DateTimeZoneIndex.unpackChronology(packedEpochMillis), session.getLocale(), DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis), formatString);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        return DateTimeFunctions.dateFormat(DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())), session.getLocale(), DateTimes.roundToEpochMillis(timestamp), formatString);
    }
}

