/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.DateTimes;
import java.time.Instant;
import java.time.ZoneId;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimeZoneToTimeCast {
    private TimestampWithTimeZoneToTimeCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") long packedEpochMillis) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        ZoneId zoneId = DateTimeEncoding.unpackZoneKey((long)packedEpochMillis).getZoneId();
        return TimestampWithTimeZoneToTimeCast.convert(targetPrecision, epochMillis, 0L, zoneId);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        return TimestampWithTimeZoneToTimeCast.convert(targetPrecision, timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()).getZoneId());
    }

    private static long convert(long targetPrecision, long epochMillis, long picosOfMilli, ZoneId zoneId) {
        long nanoOfDay = Instant.ofEpochMilli(epochMillis).atZone(zoneId).toLocalDateTime().toLocalTime().toNanoOfDay();
        long picoOfDay = DateTimes.rescale(nanoOfDay, 9, 12) + picosOfMilli;
        return DateTimes.round(picoOfDay, (int)(12L - targetPrecision)) % 86400000000000000L;
    }
}

