/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.util.Failures;

@ScalarFunction(value="$at_timezone", hidden=true)
public class AtTimeZoneWithOffset {
    private AtTimeZoneWithOffset() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static long atTimeZone(@SqlType(value="time(p) with time zone") long packedTime, @SqlType(value="interval day to second") long zoneOffset) {
        int offsetMinutes = AtTimeZoneWithOffset.getZoneOffsetMinutes(zoneOffset);
        long nanos = DateTimeEncoding.unpackTimeNanos((long)packedTime) - (long)(DateTimeEncoding.unpackOffsetMinutes((long)packedTime) - offsetMinutes) * 60000000000L;
        return DateTimeEncoding.packTimeWithTimeZone((long)Math.floorMod(nanos, 86400000000000L), (int)offsetMinutes);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static LongTimeWithTimeZone atTimeZone(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone time, @SqlType(value="interval day to second") long zoneOffset) {
        int offsetMinutes = AtTimeZoneWithOffset.getZoneOffsetMinutes(zoneOffset);
        long picos = time.getPicoSeconds() - (long)(time.getOffsetMinutes() - offsetMinutes) * 60000000000000L;
        return new LongTimeWithTimeZone(Math.floorMod(picos, 86400000000000000L), AtTimeZoneWithOffset.getZoneOffsetMinutes(zoneOffset));
    }

    private static int getZoneOffsetMinutes(long interval) {
        Failures.checkCondition(interval % 60000L == 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid time zone offset interval: interval contains seconds", new Object[0]);
        return Math.toIntExact(interval / 60000L);
    }
}

