/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.timetz.TimeWithTimeZoneOperators;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import java.util.Locale;

@Description(value="Difference of the given times in the given unit")
@ScalarFunction(value="date_diff")
public class DateDiff {
    private DateDiff() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
        String unitString;
        long nanos = TimeWithTimeZoneOperators.normalize(right) - TimeWithTimeZoneOperators.normalize(left);
        switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond": {
                return nanos / 1000000L;
            }
            case "second": {
                return nanos / 1000000000L;
            }
            case "minute": {
                return nanos / 60000000000L;
            }
            case "hour": {
                return nanos / 3600000000000L;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid Time field");
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
        String unitString;
        long picos = TimeWithTimeZoneOperators.normalize(right) - TimeWithTimeZoneOperators.normalize(left);
        switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond": {
                return picos / 1000000000L;
            }
            case "second": {
                return picos / 1000000000000L;
            }
            case "minute": {
                return picos / 60000000000000L;
            }
            case "hour": {
                return picos / 3600000000000000L;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid Time field");
    }
}

