/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.prestosql.operator.scalar.time.TimeOperators;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.type.Constraint;
import io.prestosql.type.DateTimes;

public final class TimeWithTimeZoneOperators {
    private TimeWithTimeZoneOperators() {
    }

    static long normalize(long packedTime) {
        long nanos = DateTimeEncoding.unpackTimeNanos((long)packedTime);
        int offsetMinutes = DateTimeEncoding.unpackOffsetMinutes((long)packedTime);
        return Math.floorMod(nanos - (long)offsetMinutes * 60000000000L, 86400000000000L);
    }

    static long normalize(LongTimeWithTimeZone time) {
        return Math.floorMod(time.getPicoSeconds() - (long)time.getOffsetMinutes() * 60000000000000L, 86400000000000000L);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimeMinusTime {
        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
            long nanos = TimeWithTimeZoneOperators.normalize(left) - TimeWithTimeZoneOperators.normalize(right);
            return DateTimes.rescaleWithRounding(nanos, 9, 3);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
            long picos = TimeWithTimeZoneOperators.normalize(left) - TimeWithTimeZoneOperators.normalize(right);
            return DateTimes.rescaleWithRounding(picos, 12, 3);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimeMinusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long subtract(@SqlType(value="time(p) with time zone") long packedTime, @SqlType(value="interval day to second") long interval) {
            return TimePlusIntervalDayToSecond.add(packedTime, -interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimeWithTimeZone subtract(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone time, @SqlType(value="interval day to second") long interval) {
            return TimePlusIntervalDayToSecond.add(time, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalDayToSecondPlusTime {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@SqlType(value="interval day to second") long interval, @SqlType(value="time(p) with time zone") long time) {
            return TimePlusIntervalDayToSecond.add(time, interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimeWithTimeZone add(@SqlType(value="interval day to second") long interval, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
            return TimePlusIntervalDayToSecond.add(time, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimePlusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@SqlType(value="time(p) with time zone") long packedTime, @SqlType(value="interval day to second") long interval) {
            long picos = DateTimeEncoding.unpackTimeNanos((long)packedTime) * 1000L;
            long nanos = TimeOperators.add(picos, interval * 1000000000L) / 1000L;
            return DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)DateTimeEncoding.unpackOffsetMinutes((long)packedTime));
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimeWithTimeZone add(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone time, @SqlType(value="interval day to second") long interval) {
            long picos = TimeOperators.add(time.getPicoSeconds(), interval * 1000000000L);
            return new LongTimeWithTimeZone(picos, time.getOffsetMinutes());
        }
    }
}

