/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;

@Description(value="Time zone hour of the given time")
@ScalarFunction(value="timezone_hour")
public final class TimeZoneHour {
    private TimeZoneHour() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="time(p) with time zone") long packedTime) {
        return (long)DateTimeEncoding.unpackOffsetMinutes((long)packedTime) / 60L;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
        return (long)time.getOffsetMinutes() / 60L;
    }
}

