/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.RankingWindowFunction;
import io.prestosql.spi.function.WindowFunctionSignature;
import io.prestosql.spi.type.DoubleType;

@WindowFunctionSignature(name="cume_dist", returnType="double")
public class CumulativeDistributionFunction
extends RankingWindowFunction {
    private long totalCount;
    private long count;

    public void reset() {
        this.totalCount = this.windowIndex.size();
        this.count = 0L;
    }

    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount, int currentPosition) {
        if (newPeerGroup) {
            this.count += (long)peerGroupCount;
        }
        DoubleType.DOUBLE.writeDouble(output, (double)this.count / (double)this.totalCount);
    }
}

