/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import com.google.common.collect.Iterables;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.ValueWindowFunction;
import io.prestosql.spi.function.WindowFunctionSignature;
import java.util.List;

@WindowFunctionSignature(name="last_value", typeVariable="T", returnType="T", argumentTypes={"T"})
public class LastValueFunction
extends ValueWindowFunction {
    private final int argumentChannel;
    private final boolean ignoreNulls;

    public LastValueFunction(List<Integer> argumentChannels, boolean ignoreNulls) {
        this.argumentChannel = (Integer)Iterables.getOnlyElement(argumentChannels);
        this.ignoreNulls = ignoreNulls;
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        int valuePosition;
        if (frameStart < 0) {
            output.appendNull();
            return;
        }
        if (this.ignoreNulls) {
            for (valuePosition = frameEnd; valuePosition >= frameStart && this.windowIndex.isNull(this.argumentChannel, valuePosition); --valuePosition) {
            }
            if (valuePosition < frameStart) {
                output.appendNull();
                return;
            }
        }
        this.windowIndex.appendTo(this.argumentChannel, valuePosition, output);
    }
}

