/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.resolver.ArtifactResolver;
import io.airlift.resolver.DefaultArtifact;
import io.prestosql.connector.ConnectorManager;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.execution.resourcegroups.ResourceGroupManager;
import io.prestosql.metadata.FunctionExtractor;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.GroupProviderManager;
import io.prestosql.server.PluginClassLoader;
import io.prestosql.server.PluginDiscovery;
import io.prestosql.server.PluginManagerConfig;
import io.prestosql.server.SessionPropertyDefaults;
import io.prestosql.server.security.CertificateAuthenticatorManager;
import io.prestosql.server.security.PasswordAuthenticatorManager;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.eventlistener.EventListenerFactory;
import io.prestosql.spi.resourcegroups.ResourceGroupConfigurationManagerFactory;
import io.prestosql.spi.security.CertificateAuthenticatorFactory;
import io.prestosql.spi.security.GroupProviderFactory;
import io.prestosql.spi.security.PasswordAuthenticatorFactory;
import io.prestosql.spi.security.SystemAccessControlFactory;
import io.prestosql.spi.session.SessionPropertyConfigurationManagerFactory;
import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.Type;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.sonatype.aether.artifact.Artifact;

@ThreadSafe
public class PluginManager {
    private static final ImmutableList<String> SPI_PACKAGES = ImmutableList.builder().add((Object)"io.prestosql.spi.").add((Object)"com.fasterxml.jackson.annotation.").add((Object)"io.airlift.slice.").add((Object)"org.openjdk.jol.").build();
    private static final Logger log = Logger.get(PluginManager.class);
    private final ConnectorManager connectorManager;
    private final MetadataManager metadataManager;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final AccessControlManager accessControlManager;
    private final PasswordAuthenticatorManager passwordAuthenticatorManager;
    private final CertificateAuthenticatorManager certificateAuthenticatorManager;
    private final EventListenerManager eventListenerManager;
    private final GroupProviderManager groupProviderManager;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final ArtifactResolver resolver;
    private final File installedPluginsDir;
    private final List<String> plugins;
    private final AtomicBoolean pluginsLoading = new AtomicBoolean();
    private final AtomicBoolean pluginsLoaded = new AtomicBoolean();

    @Inject
    public PluginManager(NodeInfo nodeInfo, PluginManagerConfig config, ConnectorManager connectorManager, MetadataManager metadataManager, ResourceGroupManager<?> resourceGroupManager, AccessControlManager accessControlManager, PasswordAuthenticatorManager passwordAuthenticatorManager, CertificateAuthenticatorManager certificateAuthenticatorManager, EventListenerManager eventListenerManager, GroupProviderManager groupProviderManager, SessionPropertyDefaults sessionPropertyDefaults) {
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        this.installedPluginsDir = config.getInstalledPluginsDir();
        this.plugins = config.getPlugins() == null ? ImmutableList.of() : ImmutableList.copyOf(config.getPlugins());
        this.resolver = new ArtifactResolver(config.getMavenLocalRepository(), config.getMavenRemoteRepository());
        this.connectorManager = Objects.requireNonNull(connectorManager, "connectorManager is null");
        this.metadataManager = Objects.requireNonNull(metadataManager, "metadataManager is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.accessControlManager = Objects.requireNonNull(accessControlManager, "accessControlManager is null");
        this.passwordAuthenticatorManager = Objects.requireNonNull(passwordAuthenticatorManager, "passwordAuthenticatorManager is null");
        this.certificateAuthenticatorManager = Objects.requireNonNull(certificateAuthenticatorManager, "certificateAuthenticatorManager is null");
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.groupProviderManager = Objects.requireNonNull(groupProviderManager, "groupProviderManager is null");
        this.sessionPropertyDefaults = Objects.requireNonNull(sessionPropertyDefaults, "sessionPropertyDefaults is null");
    }

    public void loadPlugins() throws Exception {
        if (!this.pluginsLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : PluginManager.listFiles(this.installedPluginsDir)) {
            if (!file.isDirectory()) continue;
            this.loadPlugin(file.getAbsolutePath());
        }
        for (String plugin : this.plugins) {
            this.loadPlugin(plugin);
        }
        this.metadataManager.verifyTypes();
        this.pluginsLoaded.set(true);
    }

    private void loadPlugin(String plugin) throws Exception {
        log.info("-- Loading plugin %s --", new Object[]{plugin});
        PluginClassLoader pluginClassLoader = this.buildClassLoader(plugin);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)pluginClassLoader);){
            this.loadPlugin(pluginClassLoader);
        }
        log.info("-- Finished loading plugin %s --", new Object[]{plugin});
    }

    private void loadPlugin(PluginClassLoader pluginClassLoader) {
        ServiceLoader<Plugin> serviceLoader = ServiceLoader.load(Plugin.class, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        Preconditions.checkState((!plugins.isEmpty() ? 1 : 0) != 0, (String)"No service providers of type %s", (Object)Plugin.class.getName());
        for (Plugin plugin : plugins) {
            log.info("Installing %s", new Object[]{plugin.getClass().getName()});
            this.installPlugin(plugin, pluginClassLoader::duplicate);
        }
    }

    public void installPlugin(Plugin plugin, Supplier<ClassLoader> duplicatePluginClassLoaderFactory) {
        this.installPluginInternal(plugin, duplicatePluginClassLoaderFactory);
        this.metadataManager.verifyTypes();
    }

    private void installPluginInternal(Plugin plugin, Supplier<ClassLoader> duplicatePluginClassLoaderFactory) {
        for (BlockEncoding blockEncoding : plugin.getBlockEncodings()) {
            log.info("Registering block encoding %s", new Object[]{blockEncoding.getName()});
            this.metadataManager.addBlockEncoding(blockEncoding);
        }
        for (Type type : plugin.getTypes()) {
            log.info("Registering type %s", new Object[]{type.getTypeSignature()});
            this.metadataManager.addType(type);
        }
        for (ParametricType parametricType : plugin.getParametricTypes()) {
            log.info("Registering parametric type %s", new Object[]{parametricType.getName()});
            this.metadataManager.addParametricType(parametricType);
        }
        for (ConnectorFactory connectorFactory : plugin.getConnectorFactories()) {
            log.info("Registering connector %s", new Object[]{connectorFactory.getName()});
            this.connectorManager.addConnectorFactory(connectorFactory, duplicatePluginClassLoaderFactory);
        }
        for (Class functionClass : plugin.getFunctions()) {
            log.info("Registering functions from %s", new Object[]{functionClass.getName()});
            this.metadataManager.addFunctions(FunctionExtractor.extractFunctions(functionClass));
        }
        for (SessionPropertyConfigurationManagerFactory sessionConfigFactory : plugin.getSessionPropertyConfigurationManagerFactories()) {
            log.info("Registering session property configuration manager %s", new Object[]{sessionConfigFactory.getName()});
            this.sessionPropertyDefaults.addConfigurationManagerFactory(sessionConfigFactory);
        }
        for (ResourceGroupConfigurationManagerFactory configurationManagerFactory : plugin.getResourceGroupConfigurationManagerFactories()) {
            log.info("Registering resource group configuration manager %s", new Object[]{configurationManagerFactory.getName()});
            this.resourceGroupManager.addConfigurationManagerFactory(configurationManagerFactory);
        }
        for (SystemAccessControlFactory accessControlFactory : plugin.getSystemAccessControlFactories()) {
            log.info("Registering system access control %s", new Object[]{accessControlFactory.getName()});
            this.accessControlManager.addSystemAccessControlFactory(accessControlFactory);
        }
        for (PasswordAuthenticatorFactory authenticatorFactory : plugin.getPasswordAuthenticatorFactories()) {
            log.info("Registering password authenticator %s", new Object[]{authenticatorFactory.getName()});
            this.passwordAuthenticatorManager.addPasswordAuthenticatorFactory(authenticatorFactory);
        }
        for (PasswordAuthenticatorFactory authenticatorFactory : plugin.getCertificateAuthenticatorFactories()) {
            log.info("Registering certificate authenticator %s", new Object[]{authenticatorFactory.getName()});
            this.certificateAuthenticatorManager.addCertificateAuthenticatorFactory((CertificateAuthenticatorFactory)authenticatorFactory);
        }
        for (EventListenerFactory eventListenerFactory : plugin.getEventListenerFactories()) {
            log.info("Registering event listener %s", new Object[]{eventListenerFactory.getName()});
            this.eventListenerManager.addEventListenerFactory(eventListenerFactory);
        }
        for (GroupProviderFactory groupProviderFactory : plugin.getGroupProviderFactories()) {
            log.info("Registering group provider %s", new Object[]{groupProviderFactory.getName()});
            this.groupProviderManager.addGroupProviderFactory(groupProviderFactory);
        }
    }

    private PluginClassLoader buildClassLoader(String plugin) throws Exception {
        File file = new File(plugin);
        if (file.isFile() && (file.getName().equals("pom.xml") || file.getName().endsWith(".pom"))) {
            return this.buildClassLoaderFromPom(file);
        }
        if (file.isDirectory()) {
            return this.buildClassLoaderFromDirectory(file);
        }
        return this.buildClassLoaderFromCoordinates(plugin);
    }

    private PluginClassLoader buildClassLoaderFromPom(File pomFile) throws Exception {
        List artifacts = this.resolver.resolvePom(pomFile);
        PluginClassLoader classLoader = this.createClassLoader(artifacts, pomFile.getPath());
        Artifact artifact = (Artifact)artifacts.get(0);
        Set<String> plugins = PluginDiscovery.discoverPlugins(artifact, classLoader);
        if (!plugins.isEmpty()) {
            File root = new File(artifact.getFile().getParentFile().getCanonicalFile(), "plugin-discovery");
            PluginDiscovery.writePluginServices(plugins, root);
            log.debug("    %s", new Object[]{root});
            classLoader = classLoader.withUrl(root.toURI().toURL());
        }
        return classLoader;
    }

    private PluginClassLoader buildClassLoaderFromDirectory(File dir) throws Exception {
        log.debug("Classpath for %s:", new Object[]{dir.getName()});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : PluginManager.listFiles(dir)) {
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private PluginClassLoader buildClassLoaderFromCoordinates(String coordinates) throws Exception {
        DefaultArtifact rootArtifact = new DefaultArtifact(coordinates);
        List artifacts = this.resolver.resolveArtifacts(new Artifact[]{rootArtifact});
        return this.createClassLoader(artifacts, rootArtifact.toString());
    }

    private PluginClassLoader createClassLoader(List<Artifact> artifacts, String name) throws IOException {
        log.debug("Classpath for %s:", new Object[]{name});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : PluginManager.sortedArtifacts(artifacts)) {
            if (artifact.getFile() == null) {
                throw new RuntimeException("Could not resolve artifact: " + artifact);
            }
            File file = artifact.getFile().getCanonicalFile();
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private PluginClassLoader createClassLoader(List<URL> urls) {
        ClassLoader parent = this.getClass().getClassLoader();
        return new PluginClassLoader(urls, parent, (List<String>)SPI_PACKAGES);
    }

    private static List<File> listFiles(File installedPluginsDir) {
        Object[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            Arrays.sort(files);
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static List<Artifact> sortedArtifacts(List<Artifact> artifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts);
        list.sort((Comparator<Artifact>)Ordering.natural().nullsLast().onResultOf(Artifact::getFile));
        return list;
    }
}

