/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.remotetask;

import com.google.common.net.MediaType;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.prestosql.execution.DynamicFiltersCollector;
import io.prestosql.execution.TaskId;
import io.prestosql.server.DynamicFilterService;
import io.prestosql.server.remotetask.RemoteTaskStats;
import io.prestosql.server.remotetask.RequestErrorTracker;
import io.prestosql.server.remotetask.SimpleHttpResponseCallback;
import io.prestosql.server.remotetask.SimpleHttpResponseHandler;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;

class DynamicFiltersFetcher
implements SimpleHttpResponseCallback<DynamicFiltersCollector.VersionedDynamicFilterDomains> {
    private final TaskId taskId;
    private final URI taskUri;
    private final Consumer<Throwable> onFail;
    private final JsonCodec<DynamicFiltersCollector.VersionedDynamicFilterDomains> dynamicFilterDomainsCodec;
    private final Duration refreshMaxWait;
    private final Executor executor;
    private final HttpClient httpClient;
    private final RequestErrorTracker errorTracker;
    private final RemoteTaskStats stats;
    private final DynamicFilterService dynamicFilterService;
    private final AtomicLong currentRequestStartNanos = new AtomicLong();
    @GuardedBy(value="this")
    private long dynamicFiltersVersion = 0L;
    @GuardedBy(value="this")
    private long localDynamicFiltersVersion = 0L;
    @GuardedBy(value="this")
    private boolean running;
    @GuardedBy(value="this")
    private ListenableFuture<FullJsonResponseHandler.JsonResponse<DynamicFiltersCollector.VersionedDynamicFilterDomains>> future;

    public DynamicFiltersFetcher(Consumer<Throwable> onFail, TaskId taskId, URI taskUri, Duration refreshMaxWait, JsonCodec<DynamicFiltersCollector.VersionedDynamicFilterDomains> dynamicFilterDomainsCodec, Executor executor, HttpClient httpClient, Duration maxErrorDuration, ScheduledExecutorService errorScheduledExecutor, RemoteTaskStats stats, DynamicFilterService dynamicFilterService) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.taskUri = Objects.requireNonNull(taskUri, "taskUri is null");
        this.onFail = Objects.requireNonNull(onFail, "onFail is null");
        this.refreshMaxWait = Objects.requireNonNull(refreshMaxWait, "refreshMaxWait is null");
        this.dynamicFilterDomainsCodec = Objects.requireNonNull(dynamicFilterDomainsCodec, "dynamicFilterDomainsCodec is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.errorTracker = new RequestErrorTracker(taskId, taskUri, maxErrorDuration, errorScheduledExecutor, "getting dynamic filter domains");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.fetchDynamicFiltersIfNecessary();
    }

    public synchronized void stop() {
        this.running = false;
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    public synchronized void updateDynamicFiltersVersion(long newDynamicFiltersVersion) {
        if (this.dynamicFiltersVersion >= newDynamicFiltersVersion) {
            return;
        }
        this.dynamicFiltersVersion = newDynamicFiltersVersion;
        this.fetchDynamicFiltersIfNecessary();
    }

    private synchronized void fetchDynamicFiltersIfNecessary() {
        if (!this.running) {
            return;
        }
        if (this.localDynamicFiltersVersion >= this.dynamicFiltersVersion) {
            return;
        }
        if (this.future != null && !this.future.isDone()) {
            return;
        }
        ListenableFuture<?> errorRateLimit = this.errorTracker.acquireRequestPermit();
        if (!errorRateLimit.isDone()) {
            errorRateLimit.addListener(this::fetchDynamicFiltersIfNecessary, this.executor);
            return;
        }
        Request request = Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.taskUri).appendPath("dynamicfilters").build()).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setHeader("X-Presto-Current-Version", Long.toString(this.localDynamicFiltersVersion)).setHeader("X-Presto-Max-Wait", this.refreshMaxWait.toString()).build();
        this.errorTracker.startRequest();
        this.future = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(this.dynamicFilterDomainsCodec));
        this.currentRequestStartNanos.set(System.nanoTime());
        Futures.addCallback(this.future, new SimpleHttpResponseHandler<DynamicFiltersCollector.VersionedDynamicFilterDomains>(this, request.getUri(), this.stats), (Executor)this.executor);
    }

    @Override
    public void success(DynamicFiltersCollector.VersionedDynamicFilterDomains newDynamicFilterDomains) {
        try (SetThreadName ignored = new SetThreadName("DynamicFiltersFetcher-%s", new Object[]{this.taskId});){
            this.updateStats(this.currentRequestStartNanos.get());
            try {
                this.updateDynamicFilterDomains(newDynamicFilterDomains);
                this.errorTracker.requestSucceeded();
            }
            finally {
                this.fetchDynamicFiltersIfNecessary();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable cause) {
        try (SetThreadName ignored = new SetThreadName("DynamicFiltersFetcher-%s", new Object[]{this.taskId});){
            this.updateStats(this.currentRequestStartNanos.get());
            try {
                this.errorTracker.requestFailed(cause);
            }
            catch (Error e) {
                this.onFail.accept(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.onFail.accept(e);
            }
            finally {
                this.fetchDynamicFiltersIfNecessary();
            }
        }
    }

    @Override
    public void fatal(Throwable cause) {
        try (SetThreadName ignored = new SetThreadName("DynamicFiltersFetcher-%s", new Object[]{this.taskId});){
            this.updateStats(this.currentRequestStartNanos.get());
            this.onFail.accept(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDynamicFilterDomains(DynamicFiltersCollector.VersionedDynamicFilterDomains newDynamicFilterDomains) {
        DynamicFiltersFetcher dynamicFiltersFetcher = this;
        synchronized (dynamicFiltersFetcher) {
            if (this.localDynamicFiltersVersion >= newDynamicFilterDomains.getVersion()) {
                return;
            }
            this.localDynamicFiltersVersion = newDynamicFilterDomains.getVersion();
            this.updateDynamicFiltersVersion(this.localDynamicFiltersVersion);
        }
        this.dynamicFilterService.addTaskDynamicFilters(this.taskId, newDynamicFilterDomains.getDynamicFilterDomains());
    }

    private void updateStats(long currentRequestStartNanos) {
        this.stats.statusRoundTripMillis(Duration.nanosSince((long)currentRequestStartNanos).toMillis());
    }
}

