/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.base.Strings;
import io.prestosql.server.security.AuthenticationException;
import io.prestosql.server.security.Authenticator;
import io.prestosql.server.security.BasicAuthCredentials;
import io.prestosql.server.security.InsecureAuthenticatorConfig;
import io.prestosql.server.security.UserMapping;
import io.prestosql.server.security.UserMappingException;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.Identity;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class InsecureAuthenticator
implements Authenticator {
    private final UserMapping userMapping;

    @Inject
    public InsecureAuthenticator(InsecureAuthenticatorConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
    }

    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        String user;
        Optional<BasicAuthCredentials> basicAuthCredentials = BasicAuthCredentials.extractBasicAuthCredentials(request);
        if (basicAuthCredentials.isPresent()) {
            if (basicAuthCredentials.get().getPassword().isPresent()) {
                throw new AuthenticationException("Password not allowed for insecure authentication", "Basic realm=\"Presto\"");
            }
            user = basicAuthCredentials.get().getUser();
        } else {
            user = Strings.emptyToNull((String)((String)request.getHeaders().getFirst((Object)"X-Presto-User")));
        }
        if (user == null) {
            throw new AuthenticationException("Basic authentication or X-Presto-User must be sent", "Basic realm=\"Presto\"");
        }
        try {
            String authenticatedUser = this.userMapping.mapUser(user);
            return Identity.forUser((String)authenticatedUser).withPrincipal((Principal)new BasicPrincipal(user)).build();
        }
        catch (UserMappingException e) {
            throw new AuthenticationException(e.getMessage());
        }
    }
}

