/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.base.util.JsonUtils;
import io.prestosql.server.security.UserMappingException;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UserMapping {
    private final List<Rule> rules;

    public static UserMapping createUserMapping(Optional<String> userMappingPattern, Optional<File> userMappingFile) {
        if (userMappingPattern.isPresent()) {
            Preconditions.checkArgument((boolean)userMappingFile.isEmpty(), (Object)"user mapping pattern and file can not both be set");
            return new UserMapping((List<Rule>)ImmutableList.of((Object)new Rule(userMappingPattern.get())));
        }
        if (userMappingFile.isPresent()) {
            List<Rule> rules = ((UserMappingRules)JsonUtils.parseJson((Path)userMappingFile.get().toPath(), UserMappingRules.class)).getRules();
            return new UserMapping(rules);
        }
        return new UserMapping((List<Rule>)ImmutableList.of((Object)new Rule("(.*)")));
    }

    @VisibleForTesting
    UserMapping(List<Rule> rules) {
        Objects.requireNonNull(rules, "rules is null");
        Preconditions.checkArgument((!rules.isEmpty() ? 1 : 0) != 0, (Object)"rules list is empty");
        this.rules = ImmutableList.copyOf(rules);
    }

    public String mapUser(String principal) throws UserMappingException {
        for (Rule rule : this.rules) {
            Optional<String> user = rule.mapUser(principal);
            if (!user.isPresent()) continue;
            return user.get();
        }
        throw new UserMappingException("No user mapping patterns match the principal");
    }

    public static final class Rule {
        private final Pattern pattern;
        private final String user;
        private final boolean allow;
        private final Case userCase;

        public Rule(String pattern) {
            this(pattern, "$1", true, Case.KEEP);
        }

        @JsonCreator
        public Rule(@JsonProperty(value="pattern") String pattern, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="allow") Optional<Boolean> allow, @JsonProperty(value="case") Optional<Case> userCase) {
            this(pattern, Objects.requireNonNull(user, "user is null").orElse("$1"), Objects.requireNonNull(allow, "allow is null").orElse(Boolean.TRUE), Objects.requireNonNull(userCase, "userCase is null").orElse(Case.KEEP));
        }

        public Rule(String pattern, String user, boolean allow, Case userCase) {
            this.pattern = Pattern.compile(Objects.requireNonNull(pattern, "pattern is null"));
            this.user = Objects.requireNonNull(user, "user is null");
            this.allow = allow;
            this.userCase = Objects.requireNonNull(userCase, "userCase is null");
        }

        public Optional<String> mapUser(String principal) throws UserMappingException {
            Matcher matcher = this.pattern.matcher(principal);
            if (!matcher.matches()) {
                return Optional.empty();
            }
            if (!this.allow) {
                throw new UserMappingException("Principal is not allowed");
            }
            String result = matcher.replaceAll(this.user).trim();
            if (result.isEmpty()) {
                throw new UserMappingException("Principal matched, but mapped user is empty");
            }
            return Optional.of(this.userCase.transform(result));
        }
    }

    static enum Case {
        KEEP{

            @Override
            public String transform(String value) {
                return value;
            }
        }
        ,
        LOWER{

            @Override
            public String transform(String value) {
                return value.toLowerCase(Locale.ENGLISH);
            }
        }
        ,
        UPPER{

            @Override
            public String transform(String value) {
                return value.toUpperCase(Locale.ENGLISH);
            }
        };


        public abstract String transform(String var1);
    }

    public static final class UserMappingRules {
        private final List<Rule> rules;

        @JsonCreator
        public UserMappingRules(@JsonProperty(value="rules") List<Rule> rules) {
            this.rules = ImmutableList.copyOf((Collection)Objects.requireNonNull(rules, "rules is null"));
        }

        public List<Rule> getRules() {
            return this.rules;
        }
    }
}

