/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.SigningKeyResolver;
import io.prestosql.server.security.jwt.JwkService;
import java.security.Key;
import java.util.Objects;
import javax.inject.Inject;

public class JwkSigningKeyResolver
implements SigningKeyResolver {
    private final JwkService keys;

    @Inject
    public JwkSigningKeyResolver(JwkService keys) {
        this.keys = Objects.requireNonNull(keys, "keys is null");
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.getKey(header);
    }

    public Key resolveSigningKey(JwsHeader header, String plaintext) {
        return this.getKey(header);
    }

    private Key getKey(JwsHeader<?> header) {
        String keyId = header.getKeyId();
        if (keyId == null) {
            throw new SignatureException("Key ID is required");
        }
        return this.keys.getKey(keyId).orElseThrow(() -> new SignatureException("Unknown signing key ID"));
    }
}

