/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.jwt;

import com.google.common.base.Strings;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.prestosql.server.security.AuthenticationException;
import io.prestosql.server.security.Authenticator;
import io.prestosql.server.security.UserMapping;
import io.prestosql.server.security.UserMappingException;
import io.prestosql.server.security.jwt.JwtAuthenticatorConfig;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.Identity;
import java.security.Principal;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class JwtAuthenticator
implements Authenticator {
    private final JwtParser jwtParser;
    private final UserMapping userMapping;

    @Inject
    public JwtAuthenticator(JwtAuthenticatorConfig config, SigningKeyResolver signingKeyResolver) {
        Objects.requireNonNull(config, "config is null");
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
        JwtParser jwtParser = Jwts.parser().setSigningKeyResolver(signingKeyResolver);
        if (config.getRequiredIssuer() != null) {
            jwtParser.requireIssuer(config.getRequiredIssuer());
        }
        if (config.getRequiredAudience() != null) {
            jwtParser.requireAudience(config.getRequiredAudience());
        }
        this.jwtParser = jwtParser;
    }

    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        String header = Strings.nullToEmpty((String)((String)request.getHeaders().getFirst((Object)"Authorization")));
        int space = header.indexOf(32);
        if (space < 0 || !header.substring(0, space).equalsIgnoreCase("bearer")) {
            throw JwtAuthenticator.needAuthentication(null);
        }
        String token = header.substring(space + 1).trim();
        if (token.isEmpty()) {
            throw JwtAuthenticator.needAuthentication(null);
        }
        try {
            Jws claimsJws = this.jwtParser.parseClaimsJws(token);
            String subject = ((Claims)claimsJws.getBody()).getSubject();
            String authenticatedUser = this.userMapping.mapUser(subject);
            return Identity.forUser((String)authenticatedUser).withPrincipal((Principal)new BasicPrincipal(subject)).build();
        }
        catch (JwtException | UserMappingException e) {
            throw JwtAuthenticator.needAuthentication(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }

    private static AuthenticationException needAuthentication(String message) {
        return new AuthenticationException(message, "Bearer realm=\"Presto\", token_type=\"JWT\"");
    }
}

