/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class FormWebUiConfig {
    private Optional<String> sharedSecret = Optional.empty();
    private Duration sessionTimeout = new Duration(1.0, TimeUnit.DAYS);

    @NotNull
    public Optional<String> getSharedSecret() {
        return this.sharedSecret;
    }

    @Config(value="web-ui.shared-secret")
    public FormWebUiConfig setSharedSecret(String sharedSecret) {
        this.sharedSecret = Optional.ofNullable(sharedSecret);
        return this;
    }

    @NotNull
    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Config(value="web-ui.session-timeout")
    public FormWebUiConfig setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }
}

