/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slice;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DynamicFilters {
    private DynamicFilters() {
    }

    public static Expression createDynamicFilterExpression(Metadata metadata, DynamicFilterId id, Type inputType, SymbolReference input, ComparisonExpression.Operator operator) {
        return DynamicFilters.createDynamicFilterExpression(metadata, id, inputType, (Expression)input, operator);
    }

    @VisibleForTesting
    public static Expression createDynamicFilterExpression(Metadata metadata, DynamicFilterId id, Type inputType, Expression input, ComparisonExpression.Operator operator) {
        return new FunctionCallBuilder(metadata).setName(QualifiedName.of((String)"$internal$dynamic_filter_function")).addArgument(inputType, input).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral(operator.toString())).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral(id.toString())).build();
    }

    @VisibleForTesting
    public static Expression createDynamicFilterExpression(Metadata metadata, DynamicFilterId id, Type inputType, Expression input) {
        return DynamicFilters.createDynamicFilterExpression(metadata, id, inputType, input, ComparisonExpression.Operator.EQUAL);
    }

    public static ExtractResult extractDynamicFilters(Expression expression) {
        List<Expression> conjuncts = ExpressionUtils.extractConjuncts(expression);
        ImmutableList.Builder staticConjuncts = ImmutableList.builder();
        ImmutableList.Builder dynamicConjuncts = ImmutableList.builder();
        for (Expression conjunct : conjuncts) {
            Optional<Descriptor> descriptor = DynamicFilters.getDescriptor(conjunct);
            if (descriptor.isPresent()) {
                dynamicConjuncts.add((Object)descriptor.get());
                continue;
            }
            staticConjuncts.add((Object)conjunct);
        }
        return new ExtractResult((List<Expression>)staticConjuncts.build(), (List<Descriptor>)dynamicConjuncts.build());
    }

    public static Multimap<DynamicFilterId, Descriptor> extractSourceSymbols(List<Descriptor> dynamicFilters) {
        return (Multimap)dynamicFilters.stream().collect(ImmutableListMultimap.toImmutableListMultimap(Descriptor::getId, descriptor -> new Descriptor(descriptor.getId(), (Expression)DynamicFilters.extractSourceSymbol(descriptor).toSymbolReference(), descriptor.getOperator())));
    }

    private static Symbol extractSourceSymbol(Descriptor descriptor) {
        Expression dynamicFilterExpression = descriptor.getInput();
        if (dynamicFilterExpression instanceof SymbolReference) {
            return Symbol.from(dynamicFilterExpression);
        }
        Preconditions.checkState((boolean)(dynamicFilterExpression instanceof Cast));
        Preconditions.checkState((boolean)(((Cast)dynamicFilterExpression).getExpression() instanceof SymbolReference));
        return Symbol.from(((Cast)dynamicFilterExpression).getExpression());
    }

    public static boolean isDynamicFilter(Expression expression) {
        return DynamicFilters.getDescriptor(expression).isPresent();
    }

    public static Optional<Descriptor> getDescriptor(Expression expression) {
        if (!(expression instanceof FunctionCall)) {
            return Optional.empty();
        }
        FunctionCall functionCall = (FunctionCall)expression;
        boolean isDynamicFilterFunction = ResolvedFunction.extractFunctionName(functionCall.getName()).equals("$internal$dynamic_filter_function");
        if (!isDynamicFilterFunction) {
            return Optional.empty();
        }
        List arguments = functionCall.getArguments();
        Preconditions.checkArgument((arguments.size() == 3 ? 1 : 0) != 0, (String)"invalid arguments count: %s", (int)arguments.size());
        Expression probeSymbol = (Expression)arguments.get(0);
        Expression operatorExpression = (Expression)arguments.get(1);
        Preconditions.checkArgument((boolean)(operatorExpression instanceof StringLiteral), (String)"operatorExpression is expected to be an instance of StringLiteral: %s", (Object)operatorExpression.getClass().getSimpleName());
        String operatorExpressionString = ((StringLiteral)operatorExpression).getValue();
        ComparisonExpression.Operator operator = ComparisonExpression.Operator.valueOf((String)operatorExpressionString);
        Expression idExpression = (Expression)arguments.get(2);
        Preconditions.checkArgument((boolean)(idExpression instanceof StringLiteral), (String)"id is expected to be an instance of StringLiteral: %s", (Object)idExpression.getClass().getSimpleName());
        String id = ((StringLiteral)idExpression).getValue();
        return Optional.of(new Descriptor(new DynamicFilterId(id), probeSymbol, operator));
    }

    @ScalarFunction(value="$internal$dynamic_filter_function", hidden=true)
    public static final class Function {
        private static final String NAME = "$internal$dynamic_filter_function";

        private Function() {
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") Object input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") long input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") boolean input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") double input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Descriptor {
        private final DynamicFilterId id;
        private final Expression input;
        private final ComparisonExpression.Operator operator;

        public Descriptor(DynamicFilterId id, Expression input, ComparisonExpression.Operator operator) {
            this.id = Objects.requireNonNull(id, "id is null");
            this.input = Objects.requireNonNull(input, "input is null");
            this.operator = Objects.requireNonNull(operator, "operator is null");
        }

        public Descriptor(DynamicFilterId id, Expression input) {
            this(id, input, ComparisonExpression.Operator.EQUAL);
        }

        public DynamicFilterId getId() {
            return this.id;
        }

        public Expression getInput() {
            return this.input;
        }

        public ComparisonExpression.Operator getOperator() {
            return this.operator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.input, that.input) && Objects.equals(this.operator, that.operator);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.input, this.operator);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("input", (Object)this.input).add("operator", (Object)this.operator).toString();
        }

        public Domain applyComparison(Domain domain) {
            if (domain.isNone() || domain.isAll()) {
                return domain;
            }
            Range span = domain.getValues().getRanges().getSpan();
            switch (this.operator) {
                case EQUAL: {
                    return domain;
                }
                case LESS_THAN: {
                    Range range = Range.lessThan((Type)span.getType(), (Object)span.getHigh().getValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case LESS_THAN_OR_EQUAL: {
                    Range range = Range.lessThanOrEqual((Type)span.getType(), (Object)span.getHigh().getValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case GREATER_THAN: {
                    Range range = Range.greaterThan((Type)span.getType(), (Object)span.getLow().getValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case GREATER_THAN_OR_EQUAL: {
                    Range range = Range.greaterThanOrEqual((Type)span.getType(), (Object)span.getLow().getValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
            }
            throw new IllegalArgumentException("Unsupported dynamic filtering comparison operator: " + this.operator);
        }
    }

    public static class ExtractResult {
        private final List<Expression> staticConjuncts;
        private final List<Descriptor> dynamicConjuncts;

        public ExtractResult(List<Expression> staticConjuncts, List<Descriptor> dynamicConjuncts) {
            this.staticConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(staticConjuncts, "staticConjuncts is null"));
            this.dynamicConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(dynamicConjuncts, "dynamicConjuncts is null"));
        }

        public List<Expression> getStaticConjuncts() {
            return this.staticConjuncts;
        }

        public List<Descriptor> getDynamicConjuncts() {
            return this.dynamicConjuncts;
        }
    }
}

