/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.CompilerOperations;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SpecialForm;
import java.util.List;
import java.util.Objects;

public class IfCodeGenerator
implements BytecodeGenerator {
    private final RowExpression condition;
    private final RowExpression trueValue;
    private final RowExpression falseValue;

    public IfCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        List<RowExpression> arguments = specialForm.getArguments();
        Preconditions.checkArgument((arguments.size() == 3 ? 1 : 0) != 0);
        this.condition = arguments.get(0);
        this.trueValue = arguments.get(1);
        this.falseValue = arguments.get(2);
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context) {
        Variable wasNull = context.wasNull();
        BytecodeBlock conditionBlock = new BytecodeBlock().append(context.generate(this.condition)).comment("... and condition value was not null").append((BytecodeNode)wasNull).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, new Class[]{Boolean.TYPE}).invokeStatic(CompilerOperations.class, "and", Boolean.TYPE, new Class[]{Boolean.TYPE, Boolean.TYPE}).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        return new IfStatement().condition((BytecodeNode)conditionBlock).ifTrue(context.generate(this.trueValue)).ifFalse(context.generate(this.falseValue));
    }
}

